macroScript AtmosphericMan
category:"fooTOOLS"
tooltip:"AtmosphericMan - Manage atmospheres"
buttontext:"AtmosphericMan"
icon:#("fooTOOLS-Icons",1)
(
------------------------------------------------------------------------------------------
-- Contents:
--		AtmosphericMan - Description: Manage atmospherics
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------
-- TODO: save selection state across a RefreshAtmosphericList() call

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14) )
	)
) then (

	local thisTool = BFDtool	toolName:"AtmosphericMan"	\
								author:"John Burnett"		\
								createDate:[2000,10,04]		\
								modifyDate:[2001,08,20]		\
								version:2					\
								defFloaterSize:[285,283]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:false

	rollout DLGaboutRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do ( thisTool.closeTool() )
	)

	rollout DLGmainRollout "Main Rollout" (
		fn UpdateUI = (
			local R = DLGmainRollout
			local selCnt = 0
			local selIdx = 0
			for i in R.DLGatmosList.selection do (
				selCnt += 1
				selIdx = i
			)
			R.DLGsetOn.enabled =
				R.DLGsetOff.enabled =
				R.DLGdelete.enabled = (selCnt != 0)
			R.DLGatmosName.text = if (selCnt==1) then (GetAtmospheric selIdx).name else ""
			R.DLGatmosName.enabled = (1 == selCnt)
		)

		fn RefreshAtmosphericList = (
			local R = DLGmainRollout
			local atmosNames = #()
			if ((MaxVersion())[1] >= 4000) then (
				for i in 1 to numAtmospherics do (
					local atmos = GetAtmospheric i
					local str = if (IsActive atmos) then "* " else ""
					str += atmos.name
					append atmosNames str
				)
			) else (
				for i in 1 to numAtmospherics do
					append atmosNames (GetAtmospheric i).name
			)
			R.DLGatmosList.items = atmosNames
			R.DLGatmosList.selection = #{}
			UpdateUI()
		)

		fn GetSelAtmospherics = (
			local R = DLGmainRollout
			for i in 1 to numAtmospherics collect
				if R.DLGatmosList.selection[i] then (GetAtmospheric i) else dontCollect
		)

		fn GetSelAtmosphericsIdx = (
			local R = DLGmainRollout
			for i in R.DLGatmosList.selection.count to 1 by -1 collect
				if	(R.DLGatmosList.selection[i]) AND
					(i <= numAtmospherics) AND
					(i >= 1) then i else dontCollect
		)

		multiListBox DLGatmosList "" items:#() height:10 width:190 pos:[5,7]
		button DLGrefresh "Refresh" pos:[200,7] width:50
		button DLGselAll "All" pos:[200,35] width:50
		button DLGselNone "None" pos:[200,58] width:50
		button DLGselInvert "Invert" pos:[200,81] width:50
		edittext DLGatmosName "" pos:[2,150] width:192
		button DLGsetOn "Turn On" width:60 pos:[5,175]
		button DLGsetOff "Turn Off" width:60 pos:[67,175]
		button DLGdelete "Delete" width:60 pos:[133,175]

		on DLGatmosList selectionEnd do ( UpdateUI() )
		on DLGatmosList doubleClicked idx do
		(
			if ((MaxVersion())[1] >= 4000) then
			(
				for atmos in GetSelAtmospherics() do SetActive atmos (NOT IsActive atmos)
				RefreshAtmosphericList()
			)
		)

		on DLGrefresh pressed do ( RefreshAtmosphericList() )
		on DLGselAll pressed do (
			DLGatmosList.selection = #{1..DLGatmosList.items.count}
			UpdateUI()
		)
		on DLGselNone pressed do (
			DLGatmosList.selection = #{}
			UpdateUI()
		)
		on DLGselInvert pressed do (
			DLGatmosList.selection = -DLGatmosList.selection
			UpdateUI()
		)

		on DLGatmosName entered str do (
			if (str != "") then (
				local idx = (GetSelAtmosphericsIdx())[1]
				local atmos = GetAtmospheric idx
				atmos.name = str
			)
			RefreshAtmosphericList()
		)

		on DLGsetOn pressed do (
			for atmos in GetSelAtmospherics() do SetActive atmos true
			if ((MaxVersion())[1] >= 4000) then RefreshAtmosphericList()
		)
		on DLGsetOff pressed do (
			for atmos in GetSelAtmospherics() do SetActive atmos false
			if ((MaxVersion())[1] >= 4000) then RefreshAtmosphericList()
		)
		on DLGdelete pressed do (
			undo on (
				for i in GetSelAtmosphericsIdx() do DeleteAtmospheric i
			)
			RefreshAtmosphericList()
		)

		on DLGmainRollout open do (
			RefreshAtmosphericList()
		)
	)

	thisTool.addRoll #(DLGaboutRollout,DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
