macroScript Bounder
category:"fooTOOLS"
tooltip:"Bounder - Create Bounding Volumes For Selection"
buttontext:"Bounder"
icon:#("fooTOOLS-Icons",4)
(

------------------------------------------------------------------------------------------
-- Contents:
--		Bounder - Create bounding volumes for objects
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14) )
	)
) then (

	local thisTool = BFDtool	toolName:"Bounder"			\
								author:"John Burnett"		\
								createDate:[1999,06,16]		\
								modifyDate:[2001,05,21]		\
								version:2					\
								defFloaterSize:[170,302]

	global jbBoundColor = color 255 0 0

	rollout DLGaboutbounderRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutBounderRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutBounderRollout close do (
			thisTool.closeTool()
		)
	)

	rollout DLGbounderRollout "Bounder" (
		fn boundSel obj boundType:#box NUScale:true boundName:"" boundColor:black = (
			local smin = obj.min
			local smax = obj.max
			local bLen = [0,0,0]
			bLen.x = (smax.x-smin.x)
			bLen.y = (smax.y-smin.y)
			bLen.z = (smax.z-smin.z)
			if bLen.x <= 0.001 then return()
			if bLen.y <= 0.001 then return()
			if bLen.z <= 0.001 then return()
			local bLenMax = (fmax bLen.z (fmax bLen.x bLen.y))
			local bvol = undefined
			case boundType of (
				#box: (
					bvol = box name:(if boundName=="" then (uniqueName "BoundingBox") else boundName) wireColor:boundColor
					bvol.pos = (smin+smax)/2
					bvol.pos.z = smin.z
					bvol.width = bLen.x
					bvol.height = bLen.z
					bvol.length = bLen.y
				)
				#chamferbox: (
					bvol = chamferbox name:(if boundName=="" then (uniqueName "BoundingCBox") else boundName) wireColor:boundColor
					bvol.pos = (smin+smax)/2
					bvol.pos.z = smin.z
					bvol.width = bLen.x
					bvol.height = bLen.z
					bvol.length = bLen.y
					bvol.fillet = bLen.x / 10.0
					bvol.Fillet_Segments = 1
				)
				#sphere: (
					bvol = sphere name:(if boundName=="" then (uniqueName "BoundingSphere") else boundName) wireColor:boundColor
					bvol.pos = (smin+smax)/2
					bvol.radius = bLenMax/2
					if NUScale == true then (
						local xmod = xform()
						xmod.gizmo.scale = [bLen.x/bLenMax,bLen.y/bLenMax,bLen.z/bLenMax]
						addmodifier bvol xmod
					)
				)
				#cylinder: (
					bvol = cylinder name:(if boundName=="" then (uniqueName "BoundingCylinder") else boundName) wireColor:boundColor
					bvol.pos = (smin+smax)/2
					bvol.pos.z = smin.z
					bvol.height = smax.z-smin.z
					bvol.radius = bLenMax/2
					if NUScale == true then (
						local xmod = xform()
						xmod.gizmo.scale = [bLen.x/bLenMax,bLen.y/bLenMax,1]
						addmodifier bvol xmod
					)
				)
			)
			return bvol
		)

		label DLGboundTypeLabel "" pos:[8,8]
		dropdownlist DLGboundType "" items:#("Box","ChamferBox","Sphere","Cylinder") width:130 pos:[4,5] align:#left
		checkbox DLGNUScale "Non-Uni Scale" checked:false offset:[-8,0] enabled:false
		checkbox DLGforiIn "For Each Object" checked:true offset:[-8,0]
		checkbox DLGlink "Link To Source" checked:true offset:[-8,0]
		checkbox DLGkeepPivot "Keep Pivot" checked:true offset:[-8,0]
		checkbox DLGalign "Align to Orentation" checked:true offset:[-8,0]
		checkbox DLGnonRend "Non-Renderable" checked:false offset:[-8,0]
		--checkbox DLGdelOrgin "Delete Original" checked:false offset:[-8,0]
		checkbox DLGuseColor "Use Color" checked:true offset:[-8,0]
		colorpicker DLGboundColor color:jbBoundColor title:"Bounding Box Color" width:44 align:#right offset:[5,-22]
		edittext DLGName "" text:"_Bounder" width:134 align:#left offset:[-12,0]
		button DLGmakeBBox "Create" width:130 height:18 offset:[-2,0]

		on DLGforiIn changed state do (
			if state == false then (
				DLGbounderRollout.DLGkeepPivot.checked = false
				DLGbounderRollout.DLGkeepPivot.enabled = false
				DLGbounderRollout.DLGlink.enabled = false
			) else (
				DLGbounderRollout.DLGkeepPivot.checked = true
				DLGbounderRollout.DLGkeepPivot.enabled = true
				DLGbounderRollout.DLGlink.enabled = true
			)
		)

		on DLGusePivots changed state do (
			DLGuseColor.checked = not state
			if not state then (
				DLGboundColor.color = jbBoundColor
			) else (
				jbBoundColor = DLGboundColor.color
				DLGboundColor.color = color 197 197 197
			)
		)

		on DLGuseColor changed state do (
			DLGboundColor.enabled = state
			if state then (
				DLGboundColor.color = jbBoundColor
			) else (
				jbBoundColor = DLGboundColor.color
				DLGboundColor.color = color 197 197 197
			)
		)

		on DLGboundType selected i do (
			local boundType = (DLGbounderRollout.DLGboundType.selected as name)
			DLGNUScale.enabled = not ((boundType == #box) OR (boundType == #chamferbox))
			DLGNUScale.checked = (boundType == #cylinder)
		)

		on DLGmakeBBox pressed do (
			if selection.count >= 1 then (
					if DLGbounderRollout.DLGforiIn.checked == true then (
						delAr = #()
						for obj in selection do (
							if DLGbounderRollout.DLGalign.checked == true then (
								tempRot = coordsys world obj.rotation
								obj.rotation = quat 0 0 0 1
							)
							local bvol = (boundSel obj \
								boundType:(DLGbounderRollout.DLGboundType.selected as name) \
								NUScale:DLGbounderRollout.DLGNUScale.checked \
								boundName:(if DLGbounderRollout.DLGName.text != undefined then (obj.name + DLGbounderRollout.DLGName.text) else (uniqueName obj.name)) \
								boundColor:(if DLGuseColor.checked then DLGboundColor.color else obj.wirecolor)
							)
							if DLGbounderRollout.DLGalign.checked == true then (
								if DLGbounderRollout.DLGkeepPivot.checked then (
									bvol.pivot = obj.pivot
								)
								bvol.parent = obj
								obj.rotation = tempRot
								bvol.parent = undefined

								if DLGbounderRollout.DLGnonRend.checked then (
									bvol.renderable = false
									bvol.castShadows = false
									bvol.receiveShadows = false
									bvol.inheritVisibility = false
								)

							)
							if DLGbounderRollout.DLGlink.checked then (
								bvol.parent = obj
							)
						)
					) else (
							bvol = (boundSel selection \
								boundType:(DLGbounderRollout.DLGboundType.selected as name) \
								NUScale:DLGbounderRollout.DLGNUScale.checked \
								boundName:(if DLGbounderRollout.DLGName.text != undefined then (selection[1].name + DLGbounderRollout.DLGName.text) else (uniqueName selection[1].name)) \
								boundColor:(if DLGuseColor.checked then DLGboundColor.color else selection[1].wirecolor)
							)
							if DLGbounderRollout.DLGnonRend.checked then (
									bvol.renderable = false
									bvol.castShadows = false
									bvol.receiveShadows = false
									bvol.inheritVisibility = false
								)
						)

			)
		)
	)

	thisTool.addRoll #(DLGaboutBounderRollout, DLGbounderRollout) rolledUp:#(true, false)

	thisTool.openTool thisTool
)
)
