macroScript DeMultiplyAlpha
category:"fooTOOLS"
tooltip:"DeMultiplyAlpha - De-multiply the color in image by its alpha"
buttontext:"DeMultiplyAlpha"
icon:#("fooTOOLS-Icons",5)
(

------------------------------------------------------------------------------------------
-- Contents:
--		DeMultiply Alpha - De-multiply the color in image by its alpha.
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14) )
	)
) then (

	local thisTool = BFDtool	toolName:"DeMultiplyAlpha"	\
								author:"John Burnett"		\
								createDate:[1999,09,02]		\
								modifyDate:[2001,05,21]		\
								version:1					\
								defFloaterSize:[250,144]

	rollout DLGaboutRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do (
			thisTool.closeTool()
		)
	)

	rollout DLGdeMultiplyRollout "deMultiplyAlpha" (

		fn deMult srcBmp col = (
			local bmp = copy srcBmp
			local row
			local back = (col as point3) / 255.

			for y in 0 to (bmp.height-1) do (
				row = getPixels bmp [0,y] bmp.width
				for x in 1 to bmp.width do (
					local cSrc = row[x]
					case of (
						(cSrc.alpha >= 255): ( )
						(cSrc.alpha <= 0.0): (
							cSrc = color 0 0 0 0
						)
						default: (
							local c = (cSrc as point3) / 255.
							local ca = cSrc.alpha / 255.
							local caI = 1 - ca
							c.x = ( c.x - (back.x * caI) ) / ca
							c.y = ( c.y - (back.y * caI) ) / ca
							c.z = ( c.z - (back.z * caI) ) / ca
							cSrc.r = c.x * 255.
							cSrc.g = c.y * 255.
							cSrc.b = c.z * 255.
						)
					)
					row[x] = cSrc
				)
				setPixels bmp [0,y] row
			)
			bmp
		)

		--label DLGpreMultColorLabel "Background Color" align:#center
		colorpicker DLGpreMultColor "Background Color" color:(color 0 255 0) fieldWidth:60 height:24 title:"Pick Background Color" align:#center
		button DLGpickSrcFile "Pick Source File..." align:#center

		on DLGpreMultColor changed col do ( multCol = col )

		on DLGpickSrcFile pressed do (
			local srcBmp = selectBitmap()
			if srcBmp != undefined then (
				local bmp = deMult srcBmp DLGpreMultColor.color
				display bmp
			)
		)
	)

	thisTool.addRoll #(DLGaboutRollout, DLGdeMultiplyRollout) rolledUp:#(true,false)
	thisTool.openTool thisTool
)
)
