macroScript DisplayVelocity
category:"fooTOOLS"
tooltip:"DisplayVelocity - Display Velocity Info For A Particle System"
buttontext:"DisplayVelocity"
icon:#("fooTOOLS-Icons",6)
(

------------------------------------------------------------------------------------------
-- Contents:
--		DisplayVelocity - Description: Display Velocity Info For Given Objects
--
-- Requires:
--		jbFunctions.ms
--		jbLib.dlx
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("jbLib",1) )
	)
) then (

	local thisTool = BFDtool	toolName:"DisplayVelocity"	\
								author:"John Burnett"		\
								createDate:[2000,11,11]		\
								modifyDate:[2001,05,21]		\
								version:1					\
								defFloaterSize:[200,284]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:true

	local posCache = #()
	local theObj = undefined
	local theObjChangeHandler = undefined

	local colorGrad = #(blue,green,yellow)
	local flagColor = red

	local displayScale = 500.0
	local velLimit = 0.025

	struct PosInfo (
		posA = [0,0,0],		-- Position at currentTime
		posB = [0,0,0],		-- The end of the line segment for display, scaled by displayScale
		col = black,		-- The color of the line segment
		vel = [0,0,0],		-- Velocity vector
		velLen = 0.0,		-- Length of velocity vector
		tooFast = false )	-- True if velLen > velLimit

	fn UpdateCacheColors =
	(
		local maxVel = 0.0
		for p in posCache do
		(
			if p.velLen > maxVel then maxVel = p.velLen
		)

		for p in posCache do (
			p.col = GetNormArrayValue colorGrad (p.velLen/maxVel)
		)
	)

	fn UpdateCacheVelLimits =
	(
		for p in posCache do
		(
			p.tooFast = p.velLen > velLimit
		)
	)

	fn UpdateCacheLineSegs =
	(
		for p in posCache do
		(
			p.posB = p.posA + (p.vel * displayScale)
		)
	)

	fn UpdateCache =
	(
		posCache = #()

		if (ObjectExists theObj) then (
			for i in 1 to (ParticleCount theObj) do (
				local p = PosInfo()
				p.posA = ParticlePos theObj i

				if (undefined == p.posA) then continue

				p.vel = ParticleVelocity theObj i
				p.velLen = length p.vel

				append posCache p
			)

			UpdateCacheColors()
			UpdateCacheVelLimits()
			UpdateCacheLineSegs()

			return true
		)

		false
	)

	fn DrawVelocities =
	(
		gw.enlargeUpdateRect #whole --todo: make this not necessary
		gw.setTransform (matrix3 1)

		for p in posCache do
		(
			gw.setColor #line p.col
			gw.polyline #(p.posA, p.posB) false
			if p.tooFast then gw.marker p.posA #plusSign color:flagColor
		)

		gw.updateScreen()
	)

	--	fn IsNewParticleSystem obj = (
	--		local c = classOf obj
	--		if	(Blizzard == c) OR
	--			(PArray == c) OR
	--			(PCloud == c) OR
	--			(SuperSpray == c) then
	--		(
	--			true
	--		) else (
	--			false
	--		)
	--	)

	--	fn OKatCurrentTime obj = (
	--		if (IsNewParticleSystem obj) then (
	--			if	(currentTime >= obj.Emitter_Start) AND
	--				(currentTime <= obj.Emitter_End) then
	--			(
	--				true
	--			) else (
	--				false
	--			)
	--		)
	--
	--		true
	--	)

	fn RegisterObj =
	(
		if (ObjectExists theObj) then (
			RegisterRedrawViewsCallback DrawVelocities
			RegisterTimeCallback UpdateCache
			theObjChangeHandler = when geometry theObj changes handleAt:#redrawViews do UpdateCache()

			UpdateCache()
			ForceCompleteRedraw()
		)
	)

	fn UnregisterObj =
	(
		UnRegisterRedrawViewsCallback DrawVelocities
		UnRegisterTimeCallback UpdateCache
		try (DeleteChangeHandler theObjChangeHandler) catch ()

		ForceCompleteRedraw()
	)

	fn UpdateUI =
	(
--todo: unregister callbacks if invalid
	)

	rollout DLGaboutRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do (
			UnregisterObj()

			thisTool.closeTool()
		)
	)

	rollout DLGmainRollout "Main Rollout" (
		fn UpdateUI =
		(
		)

		group "Particle System" (
			pickbutton DLGpickPartSys "Pick" filter:IsParticleSystem align:#left
			label DLGcurSystem "-- none --" align:#left offset:[50,-22]
			checkbutton DLGdrawVelocity "Draw Velocity" highlightColor:(color 255 160 160) offset:[0,5]
		)

		group "Display" (
			spinner DLGvelLimit "Velocity Flag Limit" range:[0,99999,velLimit] scale:0.01 type:#float fieldWidth:45
			spinner DLGdisplayScale "Display Scale" range:[0,99999,displayScale] scale:10 type:#float fieldWidth:45
		)
		group "Velocity Colors" (
			colorpicker DLGcolorA "" color:colorGrad[1] across:3
			colorpicker DLGcolorB "" color:colorGrad[2]
			colorpicker DLGcolorC "" color:colorGrad[3]
		)

		on DLGpickPartSys picked obj do (
			theObj = obj

			RegisterObj()
			DLGcurSystem.text = theObj.name
			DLGdrawVelocity.checked = true
		)

		on DLGdrawVelocity changed state do (
			if state then (
				RegisterObj()
			) else (
				UnregisterObj()
			)
		)

		on DLGcolorA changed col do (
			colorGrad[1] = col
			UpdateCacheColors()
			ForceCompleteRedraw()
		)
		on DLGcolorB changed col do (
			colorGrad[2] = col
			UpdateCacheColors()
			ForceCompleteRedraw()
		)
		on DLGcolorC changed col do (
			colorGrad[3] = col
			UpdateCacheColors()
			ForceCompleteRedraw()
		)

		on DLGvelLimit changed val do (
			velLimit = val
			UpdateCacheVelLimits()
			ForceCompleteRedraw()
		)
		on DLGdisplayScale changed val do (
			displayScale = val
			UpdateCacheLineSegs()
			ForceCompleteRedraw()
		)
	)

	thisTool.addRoll #(DLGaboutRollout,DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
