macroScript FrameMan
category:"fooTOOLS"
tooltip:"FrameMan - Create MOV/AVI's from file sequences"
buttontext:"FrameMan"
icon:#("fooTOOLS-Icons",8)
(

------------------------------------------------------------------------------------------
-- Contents:
--		FrameMan - Description: Create MOV/AVI's from file sequences
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14) )
	)
) then (

	local thisTool = BFDtool	toolName:"FrameMan"			\
								author:"John Burnett"		\
								createDate:[2000,05,31]		\
								modifyDate:[2001,05,21]		\
								version:7					\
								defFloaterSize:[800,400]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:false

	rollout DLGaboutRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do ( thisTool.closeTool() )
	)

	rollout DLGmainRollout "Main Rollout" (
		struct _fName (
			filename = "",
			overrideName = "",
			useOverride = false )

		local fNames -- Array of _fNames to convert
		local curIdx -- Currently selected index in fNames

		fn GetOutputFilename fName =
		(
			local fOut = ""

			-- Initial output name
			if fName.useOverride then (
				fOut =	(getFilenamePath fName.filename) +
						fName.overrideName +
						"." + DLGmainRollout.DLGfileType.selected
			) else (
				fOut =	(getFilenamePath fName.filename) +
						(getFilenameFile fName.filename) +
						"." + DLGmainRollout.DLGfileType.selected
			)

			-- Strip sequence numbers
			if DLGmainRollout.DLGstripSeqNums.checked do (
				local ints = #("0","1","2","3","4","5","6","7","8","9")
				local str = getFilenameFile fOut

				local endIdx = str.count
				local foundAlpha = false
				while (endIdx >= 2) AND NOT foundAlpha do (
					if ((findItem ints str[endIdx]) != 0) then
						endIdx -= 1
					else
						foundAlpha = true
				)

				if endIdx >= 1 do (
					str = subString str 1 endIdx
				)
				fOut =	(getFilenamePath fOut) + str + (getFilenameType fOut)
			)

			-- Put in parent dir
			if DLGmainRollout.DLGcreateInParent.checked do (
				local fPath = getFilenamePath fOut
				fPathArray = filterString fPath "\\"
				-- fix for UNC paths
				fPath = if (fPath[1] == "\\") AND (fPath[2] == "\\") then "\\\\" else ""
				for i in 1 to (fPathArray.count-1) do fPath += (fPathArray[i] + "\\")
				fOut = fPath + (filenameFromPath fOut)
			)

			-- Append postfix text
			if DLGmainRollout.DLGusePostfix.checked do (
				fOut =	(getFilenamePath fOut) +
						(getFilenameFile fOut) +
						DLGmainRollout.DLGpostfix.text +
						(getFilenameType fOut)
			)

			fOut
		)

		fn ConvertSeq fName deleteSource:false = (
			fIn = openBitmap fName.filename
			if (fIn != undefined) then (
				fOut = bitmap	(fIn.width * (DLGmainRollout.DLGscale.value / 100))	\
								(fIn.height * (DLGmainRollout.DLGscale.value / 100))	\
								numFrames:fIn.numFrames

				fOut.filename = GetOutputFilename fName

				for i in 0 to (fIn.numFrames-1) do (
					fIn.frame = i
					copy fIn fOut
					save fOut frame:i
					if NOT (progressUpdate (i as float/fIn.numFrames * 100)) do (
						close fOut
						close fIn
						return #abort
					)
				)

				close fOut
				close fIn
			) else (
				return #fail
			)

			if deleteSource do (
				if (isFileType fName.filename "ifl") do (
					local files = getIFLfiles fName.filename

					if (files != undefined) do (
						for f in files do deleteFile f
					)
				)
				deleteFile fName.filename
			)

			return #success
		)

		fn updateUI = (
			local R = DLGmainRollout
			-- Stuff the listbox with path names
			local cnt = 0
			R.DLGseqList.items = for fName in fNames collect (
				cnt += 1
				local str = (cnt as string) + ": " +
							(filenameFromPath fName.filename)
				if fName.useOverride then str += " (" + fName.overrideName + ")"
				str += "   in   " + (getFilenamePath fName.filename)
				str
			)

			-- Update the listbox selection index
			if (fNames.count >= 1) do (
				curIdx =	if (curIdx <= 0) then 1 else
							if (curIdx > fNames.count) then fNames.count else curIdx
				R.DLGseqList.selection = curIdx
			)

			-- Enable/Disable listbox edit buttons
			R.DLGmoveUp.enabled =	(curIdx <= fNames.count) AND
									(curIdx >= 2) AND
									(fNames.count > 1)
			R.DLGmoveDown.enabled =	(curIdx <= (fNames.count-1)) AND
									(curIdx >= 1) AND
									(fNames.count > 1)

			-- Enable convert only if there are sequences picked an all have valid names
			local res = true
			for fName in fNames do (
				if fName.useOverride then res = res AND (IsValidFilename fName.overrideName)
			)
			R.DLGconvertSeq.enabled = res AND (fNames.count != 0)

			if fNames.count == 0 then (
				R.DLGfilename.text = ""
				R.DLGuseFilename.checked =
					R.DLGuseFilename.enabled =
					R.DLGfilename.enabled = false
			) else (
				R.DLGfilename.text = fNames[curIdx].overrideName
				R.DLGuseFilename.enabled = true
				R.DLGuseFilename.checked =
					R.DLGfilename.enabled = fNames[curIdx].useOverride
			)
			R.DLGpostFix.enabled = R.DLGusePostFix.checked
		)

		group "Input Sequences" (
			listbox DLGseqList height:5 width:730 offset:[0,0]
			button DLGmoveUp "/\\" tooltip:"Move Sequence Up" width:16 height:24 offset:[730,-76] align:#left
			button DLGmoveDown "\\/" tooltip:"Move Sequence Down" width:16 height:24 offset:[730,17] align:#left
			button DLGadd "Add:" tooltip:"Add Sequence" width:50 height:21 align:#left offset:[341,-3]
			dropdownlist DLGaddType "" items:#("Picked Sequence","Sequences In Picked Directory","Sequences In Immediate Sub-Directories","Sequences In All Sub-Directories") align:#left width:215 offset:[391,-26]
			button DLGremove "Remove" tooltip:"Remove Selected Sequence" width:50 height:21 align:#left offset:[609,-27]
			button DLGremoveAll "Remove All" tooltip:"Remove All Sequences" width:70 height:21 align:#left offset:[660,-26]
			checkbox DLGuseFilename "Override Output Filename:" checked:false offset:[00,-23]
			edittext DLGfilename text:"" offset:[145,-21] width:150
		)
		group "Output Options" (
			label DLGfileTypeLabel "File Type:" align:#left
			dropdownlist DLGfileType "" items:#("MOV","AVI") width:45 align:#left offset:[77,-22]
			spinner DLGscale "Scale Output:   " range:[1,1000,100] type:#integer fieldWidth:35 align:#left
			label DLGscaleLabel "%" align:#left offset:[125,-20]
			label DLGscalePresetsLabel "(presets)" align:#left offset:[150,-18]
			dropdownlist DLGscalePresets "" items:#("","25 %","50 %","100 %","150 %","200 %","400 %") width:14 align:#left offset:[195,-21]
			checkbox DLGcreateInParent "Create In Parent Dir" checked:true
			checkbox DLGusePostfix "Append Text To Filename:" checked:false
			edittext DLGpostfix text:"_Proxy" offset:[147,-21] width:80
			checkbox DLGstripSeqNums "Strip Sequence Numbers" checked:true
			checkbox DLGdeleteSource "Delete Source Footage When Done" checked:false
		)
		--button DLGupdateSeq "Update Sequences" width:110 height:30 align:#right offset:[-120,0]
		button DLGconvertSeq "Convert Sequences" width:110 height:30 align:#right --offset:[0,-35]

		on DLGseqList selected idx do (
			curIdx = idx
			updateUI()
		)
		on DLGadd pressed do (
			local files = #()

			local addType = DLGaddType.selection
			case addType of (
				1: (
					local f = SelectBitmap caption:"Select Sequence"
					if (f != undefined) do Append fNames (_fName filename:f.filename overrideName:(GetFilenameFile f.filename))
				)
				default: (
					local baseDir = GetSavePath "Select Directory With Sequences"
					--TODO: get all or some sub-dirs of fPath (depends on DLGaddType)
					--		find sequences, create IFLs, and add IFLs to "files" array
					if baseDir != undefined do (
						-- subDirs is the dirs to search for IFLs
						local subDirs = #()
						case addType of (
							2: subDirs = #(baseDir)
							3: GetSubDirs baseDir subDirs:subDirs depth:1
							4: GetSubDirs baseDir subDirs:subDirs
						)

						ProgressStart "Searching sub-dirs..."
						for i in 1 to subDirs.count do (
							local subDir = subDirs[i]
							-- get the sequences in each subdir (if any)
							local seqs = GetSequences subDir
							for seq in seqs do (
								-- create an IFL for each sequence found
								if (IsBitmapFile seq[1]) then (
									local iflFile = MakeIFL seq
									if (iflFile != undefined) do append fNames (_fName filename:iflFile overrideName:(GetFilenameFile iflFile))
								)
							)
							if NOT (ProgressUpdate (i as float/subDirs.count*100)) then exit
						)
						ProgressEnd()
					)
				)
			)

			curIdx = fNames.count

			updateUI()
		)
		on DLGmoveUp pressed do (
			swap fNames[curIdx] fNames[curIdx-1]
			curIdx -= 1
			updateUI()
		)
		on DLGmoveDown pressed do (
			swap fNames[curIdx] fNames[curIdx+1]
			curIdx += 1
			updateUI()
		)
		on DLGremove pressed do (
			deleteItem fNames curIdx
			updateUI()
		)
		on DLGremoveAll pressed do (
			if (queryBox "Are you sure you want to remove ALL sequences from list?" title:"Warning") do fNames = #()
			updateUI()
		)

		on DLGscalePresets selected idx do (
			DLGscalePresets.selection = 1
			local str = DLGscalePresets.items[idx]
			str = substring str 1 (str.count-2)
			DLGscale.value = str as integer
		)
		on DLGuseFilename changed state do (
			fNames[curIdx].useOverride = state
			updateUI()
		)
		on DLGfilename entered str do (
			-- sidnote: jbInDLGfilenameHandler is to check whether we're running
			-- through the DLGfilename handler for a second time.  This happens
			-- after an invalid name is entered, and the resulting MessageBox warning
			-- is closed (the messagebox initially steals DLGfilename focus, and then
			-- gives it back after it's closed, causing the "DLGfilename entered" handler
			-- to be called a second time before the first time is finished
			-- this is annoying
			if jbInDLGfilenameHandler == undefined then (
				global jbInDLGfilenameHandler = 1
			) else (
				jbInDLGfilenameHandler += 1
			)

			local fNameStr = GetFilenameFile str

			if IsValidFilename fNameStr then (
				fNames[curIdx].overrideName = fNameStr
				UpdateUI()
			) else (
				if (jbInDLGfilenameHandler == 1) then MessageBox "Filename Was Not Valid" title:"Warning"
				UpdateUI()
			)
			jbInDLGfilenameHandler -= 1
		)
		on DLGusePostFix changed state do ( updateUI() )

		on DLGconvertSeq pressed do (
			local failedSeq = #()
			local progCnt = 1

			for fName in fNames do (
				if (FileExists (GetOutputFilename fName)) then (
					local res = QueryBox "Some output files already exist.\n\nOverwrite all?" title:"Warning"
					if res then exit else return()
				)
			)

			for fName in fNames do (
				progressStart	(progCnt as string +
								" of " +
								fNames.count as string +
								": " +
								(getFilenameFile fName.filename))
				local res = ConvertSeq fName deleteSource:DLGdeleteSource.checked
				case res of (
					#abort: (
						progressEnd()
						exit
					)
					#fail: append failedSeq fName
					#default: ()
				)
				progCnt += 1
				progressEnd()
			)

			if failedSeq.count != 0 do (
				format "Failed To Convert Sequences:\n"
				for fName in failedSeq do format "\t%\n" fName.filename
				messageBox "Failed To Convert Some Sequences.\n\nSee listener for details." title:"Error"
			)
		)

--		on DLGupdateSeq pressed do (
--			local failedSeq = #()
--			local progCnt = 1
--
--			for fName in fNames do (
--				progressStart	(progCnt as string +
--								" of " +
--								fNames.count as string +
--								": " +
--								(getFilenameFile fName.filename))
--				local newestDate
--
--				local fType = getFilenameType fName.filename
--				fType = substring fType 2 (fType.count - 1)
--				if (fType as name == #ifl) then (
--				) else (
--					newestDate = getFileModDate fName.filename
--				)
--
--				local res = convertSeq fName
--				case res of (
--					#abort: (
--						progressEnd()
--						exit
--					)
--					#fail: append failedSeq fName
--					#default: ()
--				)
--				progCnt += 1
--				progressEnd()
--			)
--
--			if failedSeq.count != 0 do (
--				format "Failed To Convert Sequences:\n"
--				for fName in failedSeq do format "\t%\n" fName.filename
--				messageBox "Failed To Convert Some Sequences.\n\nSee listener for details." title:"Error"
--			)
--		)

		on DLGmainRollout open do (
			fNames = #()
			curIdx = 1
			updateUI()
		)
	)

	thisTool.addRoll #(DLGaboutRollout,DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
