macroScript Hunter
category:"fooTOOLS"
buttontext:"Hunter"
tooltip:"Hunter - Search The Scene For Items"
icon:#("fooTOOLS-Icons",10)
(

------------------------------------------------------------------------------------------
-- Contents:
--		Hunter - Description: Search the scene for items with specified properties,
--							  and do something to them.
--
-- Requires:
--		jbFunctions.ms
--		avg_dlx.dlx (r3.1 only)
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("avg_dlx",2.09) )
	)
) then (

	local thisTool = BFDtool	toolName:"Hunter"			\
								author:"John Burnett"		\
								createDate:[2000,03,28]		\
								modifyDate:[2001,05,21]		\
								version:3					\
								defFloaterSize:[220,559]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:true

	local huntTypes			-- array of strings, names of the different hunt types
	local huntTypesRollouts	-- array of rollouts, rollouts corresponding to the hunt names
	local huntType			-- current hunt type, points to location in above arrayes
	local huntIn			-- int, 1==all objects, 2==current selection

	-- Get the objects that should be included in the search
	fn GetHunterObjects = (
		-- TODO: add more filtering options
		local sel = case huntIn of (
			1: objects as array
			2: selection as array
		)

		return sel
	)

	-- Saves state of command panel and switches to create tab if necessary
	local cmdPanelState
	fn PushCommandPanel = (
		cmdPanelState = getCommandPanelTaskMode()
		if cmdPanelState != #create then setCommandPanelTaskMode mode:#create
	)

	-- Restore command panel
	fn PopCommandPanel = (
		if cmdPanelState != getCommandPanelTaskMode() then (
			setCommandPanelTaskMode mode:cmdPanelState
		)
	)

	rollout DLGaboutRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do ( thisTool.closeTool() )
	)

----------------------------------------------------------------------------------------------
	rollout DLGmodifierRollout "Hunt For Modifiers" (
		local curObj
		local curMod

		fn UpdateUI = (
			if (NOT objectExists curObj) OR (curObj.modifiers.count == 0) then
			(
				DLGmodifierRollout.DLGpickPrompt.text = "Pick An Object With Modifiers"
				DLGmodifierRollout.DLGmods.items = #()

				curMod = undefined
			) else (
				DLGmodifierRollout.DLGmods.items = for m in curObj.modifiers collect (
					--(snipString m.name 20) + " [" + (classOf m) as string + "]"
					(classOf m) as string
					--snipString m.name 40
				)

				if	(DLGmodifierRollout.DLGmods.selection > DLGmodifierRollout.DLGmods.items.count) OR
					(DLGmodifierRollout.DLGmods.selection <= 0) then (
					DLGmodifierRollout.DLGmods.selection = 1
				)
				curMod = curObj.modifiers[DLGmodifierRollout.DLGmods.selection]

				DLGmodifierRollout.DLGpickPrompt.text = "Object: " + snipString curObj.name 30
				--DLGmodifierRollout.DLGpickPrompt.text = "Type: " + snipString ((classOf curMod) as string) 30
			)
			DLGmodifierRollout.DLGdoSelect.enabled = NOT DLGmodifierRollout.DLGdoDeleteObj.checked
			DLGmodifierRollout.DLGdoEnable.enabled =
			DLGmodifierRollout.DLGdoDisable.enabled =
			DLGmodifierRollout.DLGdoEnableInView.enabled =
			DLGmodifierRollout.DLGdoDisableInView.enabled = NOT
				(DLGmodifierRollout.DLGdoDeleteMod.checked OR
				DLGmodifierRollout.DLGdoDeleteObj.checked)
			DLGmodifierRollout.DLGdoDeleteMod.enabled = NOT DLGmodifierRollout.DLGdoDeleteObj.checked
			DLGmodifierRollout.DLGdoDeleteObj.enabled = NOT DLGmodifierRollout.DLGdoDeleteMod.checked
		)

		fn Hunt = (
			if curMod == undefined then (
				messageBox "Nothing to find...\nPick an object and modifier first." title:"Error"
				return()
			)

			PushCommandPanel()

			local objs = GetHunterObjects()

			local foundObjs = #()
			local foundMods = #()
			local R = DLGmodifierRollout
			for obj in objs do (
				local foundMod = false
				for i in 1 to obj.modifiers.count do (
					-- quickie fix to get instanced mod searching
					if	( (R.DLGsearchFor.state == 1) AND (obj.modifiers[i] == curMod) ) OR
						( (R.DLGsearchFor.state == 2) AND ((classOf obj.modifiers[i]) == (classOf curMod)) ) then
					(
						if NOT foundMod then (
							append foundObjs obj
							append foundMods #(obj.modifiers[i])
							foundMod = true
						) else (
							append foundMods[foundMods.count] obj.modifiers[i]
						)
					)
				)
			)

			clearUndoBuffer()
			if DLGmodifierRollout.DLGdoDeleteObj.checked then (
				delete foundObjs
			) else (
				if DLGmodifierRollout.DLGdoDeleteMod.checked then (
					for i in 1 to foundObjs.count do (
						for m in foundMods[i] do (
							-- try in case some of foundObjs are instances
							try (deleteModifier foundObjs[i] m) catch ()
						)
					)
				) else (
					if DLGmodifierRollout.DLGdoEnable.checked then (
						for m in foundMods do m.enabled = true
					)
					if DLGmodifierRollout.DLGdoDisable.checked then (
						for m in foundMods do m.enabled = false
					)
					if DLGmodifierRollout.DLGdoEnableInView.checked then (
						for m in foundMods do m.enabledInViews = true
					)
					if DLGmodifierRollout.DLGdoDisableInView.checked then (
						for m in foundMods do m.enabledInViews = false
					)
				)
				if DLGmodifierRollout.DLGdoSelect.checked then ( SelectAndShow foundObjs prompt:FALSE )
			)

			PopCommandPanel()
		)

		group "Find Modifier:" (
			label DLGpickPrompt "" offset:[0,-2]
			listbox DLGmods "" items:#() height:4
			pickbutton DLGpickObj "Pick" width:60 across:2
			button DLGrefresh "Refresh" width:60
		)
		group "Search For:" (
			radiobuttons DLGsearchFor labels:#("Instances Of Modifier","Modifiers Of Same Type") columns:1 default:2 align:#left
		)
		group "When Found Do:" (
			checkbox DLGdoDeleteObj "Delete Object" align:#left
			checkbox DLGdoDeleteMod "Delete Modifier" align:#left
			checkbox DLGdoSelect "Select Object" align:#left
			checkbox DLGdoEnable "Enable" across:2
			checkbox DLGdoDisable "Disable" offset:[2,0]
			checkbox DLGdoEnableInView "On in View" across:2
			checkbox DLGdoDisableInView "Off in View" offset:[2,0]
		)
		button DLGhunt "Hunt" width:50 height:30

		on DLGmods selected idx do ( UpdateUI() )
		on DLGpickObj picked obj do ( curObj = obj; UpdateUI() )
		on DLGrefresh pressed do ( UpdateUI() )

		on DLGdoDeleteMod changed state do ( UpdateUI() )
		on DLGdoDeleteObj changed state do ( UpdateUI() )
		on DLGdoEnable changed state do ( if state then DLGdoDisable.state = false )
		on DLGdoDisable changed state do ( if state then DLGdoEnable.state = false )
		on DLGdoEnableInView changed state do ( if state then DLGdoDisableInView.state = false )
		on DLGdoDisableInView changed state do ( if state then DLGdoEnableInView.state = false )

		on DLGhunt pressed do ( UpdateUI(); Hunt() )

		on DLGmodifierRollout open do ( curObj = undefined; UpdateUI() )
	)

----------------------------------------------------------------------------------------------
	rollout DLGobjectRollout "Hunt For Objects" (
		local curObj

		fn UpdateUI = (
			if try ((curObj == undefined) OR
					(isDeleted curObj)) catch (true) then (
				DLGobjectRollout.DLGstatus01.text = "Pick An Object"
				DLGobjectRollout.DLGstatus02.text = "--------------"
				curObj = undefined
			) else (
				local tmpName = curObj.name
				local tmpMat = if (curObj.material == undefined) then "none" else curObj.material.name
				local tmpStr = (snipString tmpName 20) + " (" + (snipString tmpMat 10) + ")"
				DLGobjectRollout.DLGstatus01.text = tmpStr --snipString curObj.name 30
				DLGobjectRollout.DLGstatus02.text = (classOf curObj) as string
			)
		)

		fn Hunt = (
			if curObj == undefined then (
				messageBox "Nothing to find...\nPick an object first." title:"Error"
				return()
			)

			local objs = GetHunterObjects()
			PushCommandPanel()

			local fObjs = case DLGobjectRollout.DLGfindWhat.state of (
				1: (
					local rObjs = #(curObj) + (getInstances curObj)
					for obj in objs where ((findItem rObjs obj)!=0) collect obj
				)
				2: (
					local curClass = classOf curObj
					for obj in objs where (classOf obj == curClass) collect obj
				)
				3: (
					for obj in objs where (obj.material == curObj.material) collect obj
				)
			)

			case DLGobjectRollout.DLGdoThis.state of (
				1: ( SelectAndShow fObjs prompt:FALSE )
				2: ( delete fObjs; clearUndoBuffer() )
			)

			PopCommandPanel()
		)

		group "Object:" (
			label DLGobjectLabel "Object (Material):" align:#left
			label DLGstatus01 "" offset:[0,-2]
			label DLGtypeLabel "Type:" align:#left
			label DLGstatus02 "" offset:[0,-2]
			pickbutton DLGpickObj "Pick" offset:[-45,10]
			button DLGgrabSelected "Grab Selected" offset:[25,-26]
		)
		group "Search For:" (
			radiobuttons DLGfindWhat labels:#("Instances Of Object","Objects Of Same Type","Objects With Same Material") columns:1 default:2 align:#left
		)
		group "When Found Do:" (
			radiobuttons DLGdoThis labels:#("Select Object","Delete Object") columns:1 align:#left
		)
		button DLGhunt "Hunt" width:50 height:30

		on DLGpickObj picked obj do ( curObj = obj; UpdateUI() )
		on DLGgrabSelected pressed do ( curObj = selection[1]; UpdateUI() )
		on DLGhunt pressed do ( UpdateUI(); Hunt() )

		on DLGobjectRollout open do (
			UpdateUI()
		)
	)

----------------------------------------------------------------------------------------------
	rollout DLGtextureRollout "Hunt For Textures" (
		local findType
		local whenFound

		local FIND_INSTANCES
		local FIND_SAMETYPES
		local FIND_BITMAPTEXT

		local DO_PUT_TO_MEDIT
		local DO_SELECT_OBJ
		local DO_DELETE_OBJ
		local DO_REPLACETEXT

		local curObj
		local curTextures
		local curTex
		local searchText
		local replaceText

		fn CompareTexNames a b = ( if (a.name < b.name) then -1 else if (a.name > b.name) then 1 else 0 )

		fn UpdateUI = (
			R = DLGtextureRollout

			if (findType != FIND_BITMAPTEXT) AND (whenFound == DO_REPLACETEXT) then whenFound = DO_PUT_TO_MEDIT
			R.DLGfindType.selection = findType
			R.DLGwhenFound.selection = whenFound

			R.DLGpickPrompt.enabled =
				R.DLGtextureType.enabled =
				R.DLGtextureList.enabled =
				R.DLGpickObj.enabled =
				R.DLGrefresh.enabled = (findType == FIND_INSTANCES) OR (findType == FIND_SAMETYPES)
			R.DLGsearchText.enabled = (findType == FIND_BITMAPTEXT)
			R.DLGreplaceText.enabled = (findType == FIND_BITMAPTEXT) AND (whenFound == DO_REPLACETEXT)

			R.DLGsearchText.text = searchText
			R.DLGreplaceText.text = replaceText

			if (NOT objectExists curObj) OR (curObj.material == undefined) then
			(
				R.DLGpickPrompt.text = "Pick An Object With A Material"
				R.DLGtextureList.items = #()
				R.DLGtextureType.text = "Type: (none)"
				curTextures = #()
				curTex = undefined
			) else (
				curTextures = GetSubTextures curObj.material
				qSort curTextures CompareTexNames
				TrimDuplicates curTextures

				R.DLGtextureList.items = for tex in curTextures collect tex.name

				if	(R.DLGtextureList.selection > R.DLGtextureList.items.count) OR
					(R.DLGtextureList.selection <= 0) then (
					R.DLGtextureList.selection = 1
				)

				curTex = if (R.DLGtextureList.selection == 0) then
					undefined
				else
					curTextures[R.DLGtextureList.selection]
				R.DLGtextureType.text = "Type: " + ((classOf curTex) as string)

				R.DLGpickPrompt.text = "Object: " + (snipString curObj.name 30)
			)
		)

		fn Hunt = (
			if (findType != FIND_BITMAPTEXT) AND (curTex == undefined) then (
				messageBox "Nothing to find...\nPick an object and texture first." title:"Error"
				return()
			)

			PushCommandPanel()

			local hunterObjs = GetHunterObjects()

			local allMats = #()			-- list of materials on objects
			local allMatTextures = #()	-- array of arrays of textures for each material above
			local allMatObjects = #()	-- array of arrays of objects with material above applied

			-- run through objects and fill in above arrays
			for obj in hunterObjs where (obj.material != undefined) do (
				-- see if we've already found this material,
				-- to avoid grabbing all subtextures over and over
				local mIdx = findItem allMats obj.material

				if (mIdx == 0) then
				(
					-- if not, store it, get all it's textures, and the object it's applied to
					append allMats obj.material
					append allMatTextures (GetSubTextures obj.material)
					append allMatObjects #(obj)
				) else (
					-- otherwise just grow the object list associated with the material
					append allMatObjects[mIdx] obj
				)
			)

--			format "allMats: %\n" allMats
--			format "allMatTextures: %\n" allMatTextures
--			format "allMatObjects: %\n" allMatObjects
--			format "allTextures: %\n" allTextures

			-- now run through the allXXX arrays, and fill in the arrays below with only those
			-- objects/materials/textures that we're interested in according to the search options

			-- foundMats == array of materials that had textures meeting search criteria
			-- foundMatObjects[i] == array of objects owned by the i'th material in above array
			-- foundMatTextures[i] == array of textures that met search criteria, owned by the i'th material
			-- foundTextures == straight array of all textures that met search criteria
			local foundMats = #()
			local foundMatTextures = #()
			local foundMatObjects = #()
			local foundTextures = #()

			case findType of
			(
				FIND_INSTANCES:
				(
					append foundMatTextures #(curTex)
					append foundTextures curTex

					local fIdx
					for mIdx in 1 to allMats.count do
					(
						if (ItemFound allMatTextures[mIdx] curTex) then
						(
							append foundMats allMats[mIdx]
							append foundMatObjects allMatObjects[mIdx]
						)
					)
				)
				FIND_SAMETYPES:
				(
					local curClass = ClassOf curTex
					local tex
					for mIdx in 1 to allMats.count do
					(
						local firstTex = true
						for tIdx in 1 to allMatTextures[mIdx].count do
						(
							tex = allMatTextures[mIdx][tIdx]
							if (curClass == ClassOf tex) then
							(
								append foundTextures tex
								if (firstTex) then
								(
									firstTex = false
									append foundMats allMats[mIdx]
									append foundMatObjects allMatObjects[mIdx]
									append foundMatTextures #(tex)
								) else (
									append foundMatTextures[foundMats.count] tex
								)
							)
						)
					)
				)
				FIND_BITMAPTEXT:
				(
					local tex
					for mIdx in 1 to allMats.count do
					(
						local firstTex = true
						for tIdx in 1 to allMatTextures[mIdx].count do
						(
							tex = allMatTextures[mIdx][tIdx]
							if	(BitmapTexture == ClassOf tex) AND
								((findString tex.filename searchText) != undefined) then
							(
								append foundTextures tex
								if (firstTex) then
								(
									firstTex = false
									append foundMats allMats[mIdx]
									append foundMatObjects allMatObjects[mIdx]
									append foundMatTextures #(tex)
								) else (
									append foundMatTextures[foundMatTextures.count] tex
								)
							)
						)
					)
				)
			)
			TrimDuplicates foundTextures

--			format "foundMats: %\n" foundMats
--			format "foundMatTextures: %\n" foundMatTextures
--			format "foundMatObjects: %\n" foundMatObjects
--			format "foundTextures: %\n" foundTextures

			case whenFound of
			(
				DO_PUT_TO_MEDIT:
				(
					if (foundTextures.count > 24) then
					(
						local str = (foundTextures.count as string) + " Textures Found\n\n"
						str += "Only The First 24 Textures Will Be Shown In Medit."
						messageBox str title:"Warning"
					)
					local cnt = fMin foundTextures.count 24
					for i in 1 to cnt do (
						meditMaterials[i] = foundTextures[i]
					)
				)
				DO_SELECT_OBJ:
				(
					local sel = #()
					for objs in foundMatObjects do sel += objs

					select sel
				)
				DO_DELETE_OBJ:
				(
					local sel = #()
					for objs in foundMatObjects do sel += objs

					select sel
				)
				DO_REPLACETEXT:
				(
					for tex in foundTextures where (ClassOf tex == BitmapTexture) do
					(
						tex.filename = SearchReplace tex.filename searchText replaceText
					)
				)
			)

			PopCommandPanel()
		)

		group "Search For:" (
			dropdownlist DLGfindType items:#(
										"Instances Of Picked Texture",
										"Textures Of Picked Type",
										"Bitmaps With Filename Text")
			edittext DLGsearchText "Search:" offset:[0,3]
			label DLGpickPrompt "" offset:[0,3]
			label DLGtextureType "" align:#center offset:[0,-2]
			listbox DLGtextureList "" items:#() height:4
			pickbutton DLGpickObj "Pick Object" width:70 across:2
			button DLGrefresh "Refresh" width:70
		)
		group "When Found Do:" (
			dropdownlist DLGwhenFound items:#(
										"Put To Medit Slots",
										"Select Objects",
										"Delete Objects",
										"Replace Found Filename Text")
			edittext DLGreplaceText "Replace:"
		)
		button DLGhunt "Hunt" width:50 height:30

		on DLGfindType selected idx do ( findType = idx; UpdateUI() )
		on DLGtextureList selected idx do ( UpdateUI() )
		on DLGpickObj picked obj do (
			curObj = obj
			UpdateUI()
		)
		on DLGrefresh pressed do ( UpdateUI() )
		on DLGsearchText entered str do ( searchText = str; UpdateUI() )

		on DLGwhenFound selected idx do ( whenFound = idx; UpdateUI() )
		on DLGreplaceText entered str do ( replaceText = str; UpdateUI() )

		on DLGhunt pressed do ( UpdateUI(); Hunt() )

		on DLGtextureRollout open do (
			FIND_INSTANCES = 1
			FIND_SAMETYPES = 2
			FIND_BITMAPTEXT = 3

			DO_PUT_TO_MEDIT = 1
			DO_SELECT_OBJ = 2
			DO_DELETE_OBJ = 3
			DO_REPLACETEXT = 4

			findType = FIND_SAMETYPES
			whenFound = DO_SELECT_OBJ
			curTextures = #()
			searchText = ""
			replaceText = ""
			UpdateUI()
		)
	)

----------------------------------------------------------------------------------------------
	rollout DLGmainRollout "Main Rollout" (
		fn updateUI newType:false = (
			DLGmainRollout.DLGhuntTypes.items = huntTypes
			DLGmainRollout.DLGhuntTypes.selection = huntType
			DLGmainRollout.DLGhuntIn.state = huntIn

			if newType then (
				for i in thisTool.numRolls() to 3 by -1 do (
					thisTool.delRoll i
				)
				thisTool.addRoll huntTypesRollouts[huntType]
			)
		)

		label DLGhuntTypesLabel "Hunt For:" offset:[-57,4]
		dropdownlist DLGhuntTypes "" items:#() offset:[55,-21] width:107
		group "Search In:" (
			radiobuttons DLGhuntIn "" labels:#("All Objects","Current Selection") columns:1 align:#left
		)

		on DLGhuntTypes selected idx do (
			if idx != huntType then (
				huntType = idx
				updateUI newType:true
			)
		)
		on DLGhuntIn changed state do ( huntIn = state; UpdateUI() )

		on DLGmainRollout open do (
			huntTypes = #("Modifiers","Objects","Textures")
			huntTypesRollouts = #(DLGmodifierRollout,DLGobjectRollout,DLGtextureRollout)
			huntType = 2
			huntIn = 1
			updateUI newType:true
		)
	)

	thisTool.addRoll #(DLGaboutRollout,DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
