macroScript MaterialMan
category:"fooTOOLS"
buttontext:"MaterialMan"
tooltip:"MaterialMan - Manage various material properties"
icon:#("fooTOOLS-Icons",13)
(

------------------------------------------------------------------------------------------
-- Contents:
--		MaterialMan - Description: Manage various material properties
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14) )
	)
) then (

	local thisTool = BFDtool	toolName:"MaterialMan"		\
								author:"John Burnett"		\
								createDate:[2000,08,15]		\
								modifyDate:[2001,05,21]		\
								version:1					\
								defFloaterSize:[235,310]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:true

	rollout DLGaboutRollout "About" (
		button DLGhelp "Help"
		label DLGAbout01 "" offset:[0,5]
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGhelp pressed do (
			local helpStr = "Help Goes Here"
			messageBox helpStr title:"MaterialMan Help"
		)

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do ( thisTool.closeTool() )
	)

	local samplerTypes = #("Adaptive Halton","Adaptive Uniform","Hammersley","Max 2.5 Star")
	rollout DLGmainRollout "Main Rollout" (
		fn updateUI =
		(
-- UI elements probably shouldn't be disabled depending on sampler type
--			-- shortcut to the main rollout
--			local R = DLGmainRollout
--			local sampleType = R.DLGsamplerType.selection
--
--			-- enable adaptive only for adaptive samplers
--			R.DLGsamplerAdaptLabel.enabled =
--				R.DLGsamplerAdaptOn.enabled =
--				R.DLGsamplerAdaptOff.enabled =
--				R.DLGsamplerThreshLabel.enabled =
--				R.DLGsamplerThresh.enabled =
--				R.DLGsamplerThreshApply.enabled = (sampleType <= 2)
--			-- enable quality only for the samplers that support it
--			R.DLGsamplerQualityLabel.enabled =
--				R.DLGsamplerQuality.enabled =
--				R.DLGsamplerQualityApply.enabled = (sampleType <= 3)
		)

		-- get the materials to apply changes to
		fn getMats =
		(
			local stdMats = #()

			case DLGmainRollout.DLGapplyTo.selection of
			(
				-- get all standard materials applied to selection
				1: (
					for obj in selection do stdMats += getObjectStandardMaterials obj
				)
				-- get all standard materials applied to all objects
				2: (
					for obj in objects  do stdMats += getObjectStandardMaterials obj
				)
				-- get all standard materials in medit and scene
				3: (
					local allMats = for m in sceneMaterials collect m
					allMats += for m in meditMaterials collect m
					for m in allMats do stdMats += getStandardSubMaterials m
				)
			)

			trimDuplicates stdMats

			stdMats
		)

		groupBox DLGapplyToGroup "Apply To" pos:[2,1] width:204 height:45
			dropdownlist DLGapplyTo items:#("Materials Applied To Selected Objects","Materials Applied To All Objects","Scene And Medit Materials") pos:[5,19] width:198 height:21

		groupBox DLGsuperSamplingGroup "SuperSampling" pos:[2,50] width:205 height:173
			label DLGsamplerEnableLabel "Enabled" pos:[10,69] width:44 height:15
				button DLGsamplerOn "On" pos:[118,68] width:40 height:18
				button DLGsamplerOff "Off" pos:[161,68] width:40 height:18
			label DLGsamplerTypeLabel "Type" pos:[10,95] width:34 height:15
				dropdownlist DLGsamplerType items:samplerTypes pos:[58,91] width:100 height:21
				button DLGsamplerTypeApply "Apply" pos:[161,91] width:40 height:18
			label DLGsamplerTextureLabel "SuperSample Texture" pos:[10,121] width:102 height:15
				button DLGsamplerTextureOn "On" pos:[118,119] width:40 height:18
				button DLGsamplerTextureOff "Off" pos:[161,119] width:40 height:18
			label DLGsamplerQualityLabel "Sampler Quality" pos:[10,147] width:76 height:15
				spinner DLGsamplerQuality "" range:[0,1,0.1] type:#float scale:0.01 pos:[108,147] width:50 height:16
				button DLGsamplerQualityApply "Apply" pos:[161,146] width:40 height:18
			label DLGsamplerAdaptLabel "Adaptive" pos:[10,173] width:50 height:15
				button DLGsamplerAdaptOn "On" pos:[118,171] width:40 height:18
				button DLGsamplerAdaptOff "Off" pos:[162,171] width:40 height:18
			label DLGsamplerThreshLabel "Threshold" pos:[10,199] width:52 height:15
				spinner DLGsamplerThresh "" range:[0,1,0.1] type:#float scale:0.001 pos:[108,199] width:50 height:16
				button DLGsamplerThreshApply "Apply" pos:[161,198] width:40 height:18

--		-- Update the UI when sampler type changes
--		on DLGsamplerType selected idx do ( updateUI() )

		-- Handle applying the sampler properties
		on DLGsamplerOn pressed do ( for mat in (getMats()) do mat.samplerEnable = true )
		on DLGsamplerOff pressed do ( for mat in (getMats()) do mat.samplerEnable = false )
		on DLGsamplerTypeApply pressed do (
			for mat in (getMats()) do (
				mat.samplerByName = samplerTypes[DLGsamplerType.selection]
			)
		)
		on DLGsamplerTextureOn pressed do ( for mat in (getMats()) do mat.subSampleTextureOn = true )
		on DLGsamplerTextureOff pressed do ( for mat in (getMats()) do mat.subSampleTextureOn = false )
		on DLGsamplerQualityApply pressed do (
			for mat in (getMats()) do (
				mat.samplerQuality = DLGsamplerQuality.value
			)
		)
		on DLGsamplerAdaptOn pressed do ( for mat in (getMats()) do mat.samplerAdaptOn = true )
		on DLGsamplerAdaptOff pressed do ( for mat in (getMats()) do mat.samplerAdaptOn = false )
		on DLGsamplerThreshApply pressed do (
			for mat in (getMats()) do (
				mat.samplerAdaptThreshold = DLGsamplerThresh.value
			)
		)

		on DLGmainRollout open do ( updateUI() )
	)

	thisTool.addRoll #(DLGaboutRollout,DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
