macroScript MeshMan
category:"fooTOOLS"
buttontext:"MeshMan"
tooltip:"MeshMan - Manage various properties of editable meshes"
icon:#("fooTOOLS-Icons",17)
(

------------------------------------------------------------------------------------------
-- Contents:
--		MeshMan - Manage various properties of editable mesh faces
--
-- Requires:
--		jbFunctions.ms
--		avg_dlx.dlx (r3.x only)
--		CtrlLib.dlx (r3.x only)
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("avg_dlx",2.09), #("ctrlLib",2.2) )
	)
) then (

	local thisTool = BFDtool	toolName:"MeshMan"			\
								author:"John Burnett"		\
								createDate:[2000,02,17]		\
								modifyDate:[2001,05,21]		\
								version:2					\
								defFloaterSize:[361,489]

	local IS_MAX_4 = (MaxVersion())[1] >= 4000
	local MAP_CHANNEL_OFFSET = if (IS_MAX_4) then 1 else 0
	local VERT_COLOR_CHANNEL = if (IS_MAX_4) then 0 else 1

	local meshModeNames
	local meshModeRollouts

	rollout DLGaboutRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do (
			thisTool.closeTool()
		)
	)

-- Used to generate rollout on the fly, now just used to generate big rollout definition
--	rolloutStr = ""
--	for i in 0 to 9 do (
--		for j in 0 to 9 do (
--			local channel = (i * 10) + j
--			local channelStr = channel as string
--			local pos = [150 + (j * 18),8 + (i * 16)]
--			-- "button DLGuvChannel5 "5" tooltip:"Channel 5" width:18 height:16 pos:[90,8]"
--			if channel == 0 then (
--				rolloutStr += "\t\tcheckbutton DLGuvChannel0 \"Vertex Colors\" tooltip:\"Vertex Colors\" width:18 height:16 pos:" + pos as string + "; "
--			) else (
--				rolloutStr += "\t\tcheckbutton DLGuvChannel" + channelStr + " \"" + channelStr + "\" tooltip:\"Channel " + channelStr + "\" width:18 height:16 pos:" + pos as string + "; "
--			)
--			-- "on DLGuvChannel5 changed state do ( uvChannelHandler 5 state )"
--			rolloutStr += "on DLGuvChannel" + channelStr + " changed state do ( uvChannelHandler " + channelStr + " state )\n"
--		)
--	)
--	format rolloutStr

	-- Channel button bitmaps
	local buttonSize = [18,16]
	local UVBUTTON_BAD = #((bitmap buttonSize.x buttonSize.y color:(color 255 255 0)), undefined, 1, 1, 1, 1, 1)
	local UVBUTTON_BADALL = #((bitmap buttonSize.x buttonSize.y color:(color 255 0 0)), undefined, 1, 1, 1, 1, 1)
	local UVBUTTON_INUSE = #((bitmap buttonSize.x buttonSize.y color:(color 192 255 192)), undefined, 1, 1, 1, 1, 1)
	local UVBUTTON_INUSEALL = #((bitmap buttonSize.x buttonSize.y color:(color 0 255 0)), undefined, 1, 1, 1, 1, 1)
	local UVBUTTON_NOTINUSE = #((bitmap buttonSize.x buttonSize.y color:(color 192 192 192)), undefined, 1, 1, 1, 1, 1)

	rollout DLGUVChannelRollout "Edit UV Channels" (
		-- Various bitarray caches for channel states
		local channelInUse
		local channelInUseByAll
		local channelBad
		local channelBadAll
		-- Which channel buttons are pressed
		local uvSelectedChannels
		-- Array to the channel buttons
		local uvChannelButtons

		-- Quick defs to access clip arrays
		-- clip[SEL] = selection bitarray, size == obj.numfaces
		-- clip[SELTYPE] = name, #faces or #verts
		-- clip[TFACES] = array of tfaces, size varies (only store copied faces)
		-- clip[TVERTS] = array of tverts, size varies (only store copied verts)
		local SEL
		local SELTYPE
		local TFACES
		local TVERTS

--TODO: re-enable this
		fn supportCopyPaste = ( return FALSE )

		fn copyToClipboard useSel = (
			local obj = selection[1]
			local chan = 1 - MAP_CHANNEL_OFFSET
			local flag = false
			for i in 1 to uvSelectedChannels.count do (
				if uvSelectedChannels[i] then (
					if flag then (
						messageBox "Please Select Only One Channel" title:"Error"
						return undefined
					) else (
						flag = true
						chan = i - MAP_CHANNEL_OFFSET
					)
				)
			)
			if NOT flag then (
				messageBox "Please Select A Channel" title:"Error"
				return undefined
			)

--TODO: this IF is only necessary when vert level copy/paste is working
--			if	NOT useSel OR
--				(subObjectLevel != undefined AND
--				 subObjectLevel >= 3 AND
--				 subObjectLevel <= 5) then (
			if TRUE then (
				-- Object or face level copy...

				if (meshOp.GetMapSupport obj chan) then (
					local clip = #()
					clip[SEL] = if useSel then (getFaceSelection obj) else #{1..(obj.numFaces)}
					clip[SELTYPE] = #faces
					clip[TFACES] = #()
					clip[TVERTS] = #()

					for fIdx in 1 to clip[SEL].count do (
						if clip[SEL][fIdx] then (
							local face = (meshOp.GetMapFace obj chan fIdx)
							append clip[TFACES] face
							clip[TVERTS][face.x] = meshOp.GetMapVert obj chan face.x
							clip[TVERTS][face.y] = meshOp.GetMapVert obj chan face.y
							clip[TVERTS][face.z] = meshOp.GetMapVert obj chan face.z
						)
					)
					return clip
				) else (
					messageBox "Nothing To Copy, Channel Not Used." title:"Error"
					return undefined
				)
--TODO: what to do about tvert cut/paste?  multiple tverts per vert.... ack.
--			) else if subObjectLevel == 1 then (
--				-- Vertex level copy...
--				if (meshOp.GetMapSupport obj chan) then (
--					local clip = #()
--					clip[SEL] = getVertSelection obj
--					clip[SELTYPE] = #verts
--					clip[TFACES] = #()
--					clip[TVERTS] = #()
--
--					for vIdx in 1 to clip[SEL].count do (
--						if clip[SEL][vIdx] then (
--						)
--					)
--				) else (
--					messageBox "Nothing To Copy, Channel Not Used." title:"Error"
--					return undefined
--				)
			) else (
				local str = "UV Copy/Paste only supports face/poly/element selections."
				messageBox str title:"Error"
				return undefined
			)
		)

		fn pasteFromClipboard clip useSel = (
			local obj = selection[1]
			local chan = 1 - MAP_CHANNEL_OFFSET
			local flag = false
			for i in 1 to uvSelectedChannels.count do (
				if uvSelectedChannels[i] then (
					if flag then (
						messageBox "Please Select Only One Channel" title:"Error"
						return undefined
					) else (
						flag = true
						chan = i - MAP_CHANNEL_OFFSET
					)
				)
			)
			if NOT flag then (
				messageBox "Please Select A Channel" title:"Error"
				return undefined
			)

			local baseVertCount
			local isNewChannel = NOT (meshOp.GetMapSupport obj chan)
			if isNewChannel then (
				-- Allocate texture arrays
				baseVertCount = 0
				meshOp.SetMapSupport obj chan true
				meshOp.SetNumMapVerts obj chan clip[TVERTS].count
				meshOp.SetNumMapFaces obj chan clip[SEL].count
			) else (
				-- Make room for more tverts
				baseVertCount = meshOp.GetNumMapVerts obj chan
				meshOp.SetNumMapVerts obj chan (baseVertCount + clip[TVERTS].count) keep:true
			)

--TODO: this is all horribly, horribly borked
			local cnt = 1
			for i in 1 to clip[SEL].count do (
				if clip[SEL][i] then (
					local face = clip[TFACES][cnt]
					face += baseVertCount
					meshOp.SetMapFace obj chan i face
					cnt += 1
				) else (
					if isNewChannel then meshOp.SetMapFace obj chan i [1,1,1]
				)
			)
			for i in 1 to clip[TVERTS].count do (
				if clip[TVERTS][i] != undefined then (
					meshOp.SetMapVert obj chan (baseVertCount+i) (clip[TVERTS][baseVertCount+i])
				) else if isNewChannel then meshOp.SetMapVert obj chan i [0,0,0]
			)

			meshOp.DeleteIsoMapVerts obj chan

			update obj
		)

		-- Returns true if channel looks like it possibly has bad data
		fn isChannelBad obj chan = (
			if (meshOp.GetMapSupport obj chan) then (
				local isBad = false

				local numTFaces = meshOp.GetNumMapFaces obj chan
				local numTVerts = meshOp.GetNumMapVerts obj chan
				local i = 1
				while (i <= numTFaces) AND NOT isBad do (
					local f = meshOp.GetMapFace obj chan i
					if	(f.x > numTVerts) OR (f.x < 1) OR
						(f.y > numTVerts) OR (f.y < 1) OR
						(f.z > numTVerts) OR (f.z < 1) then (
						isBad = true
					)
					i += 1
				)

				isBad = isBad OR ( numTVerts > (obj.numFaces * 3) )

				return isBad
			) else (
				return false
			)
		)

		fn updateChannelCaches = (
			local validObjsSelected = false
			channelInUse = #{}
			channelInUseByAll = #{1..100}
			channelBad = #{}
			channelBadAll = #{1..100}

			for obj in selection do (
				if (classOf obj == editable_mesh) then (
					validObjsSelected = true
					for i in 1 to 100 do (
						local inUse = meshOp.GetMapSupport obj (i - MAP_CHANNEL_OFFSET)
						local bad = isChannelBad obj (i - MAP_CHANNEL_OFFSET)
						channelInUse[i] = inUse OR channelInUse[i]
						channelInUseByAll[i] = inUse AND channelInUseByAll[i]
						channelBad[i] = channelInUse[i] AND ( bad OR channelBad[i] )
						channelBadAll[i] = bad AND channelBadAll[i]
					)
				)
			)

			if NOT validObjsSelected then (
				channelInUse = #{}
				channelInUseByAll = #{}
				channelBad = #{}
				channelBadAll = #{}
			)
		)

		fn updateUI updateCaches:false = (
			if updateCaches then updateChannelCaches()
			for i in 1 to 100 do (
				uvChannelButtons[i].images =
					if channelBadAll[i] then UVBUTTON_BADALL else
					if channelBad[i] then UVBUTTON_BAD else
					if channelInUseByAll[i] then UVBUTTON_INUSEALL else
					if channelInUse[i] then UVBUTTON_INUSE else
					UVBUTTON_NOTINUSE
				uvChannelButtons[i].checked = uvSelectedChannels[i]
			)
		)

		-- Called when a UV Channel button changes state
		fn uvChannelHandler channel buttonState = (
			uvSelectedChannels[channel+1] = buttonState
			updateUI()
			--format "Channel: %, State: %\n" channel buttonState
		)

		-- Applies a function to a collection of objects, once per selected channel
		fn applyFunc objs func = (
			if uvSelectedChannels.count == 0 then (
				messageBox "No Channels Selected." title:"Error"
				return false
			)
			for obj in objs do (
				if (classOf obj == editable_mesh) AND (obj.modifiers.count == 0) then (
					for i in 1 to 100 do (
						if uvSelectedChannels[i] then func obj (i - MAP_CHANNEL_OFFSET)
					)
				)
			)
			updateUI updateCaches:true
			return true
		)

		-- Misc functions to use with applyFunc
		fn removeIso obj chan = (
			if (meshOp.GetMapSupport obj chan) then (
				try ( meshOp.DeleteIsoMapVerts obj chan ) catch ()
			)
		)

		fn deleteChannel obj chan = (
			if (meshOp.GetMapSupport obj chan) then (
				meshOp.FreeMapVerts obj chan
				meshOp.FreeMapFaces obj chan
				meshOp.SetMapSupport obj chan false
			)
		)
		groupBox DLGlegend "Legend" pos:[2,2] width:146 height:190
		button DLGnotInUse images:UVBUTTON_NOTINUSE width:18 height:16 enabled:false pos:[7,19]
		label DLGnotInUseLabel "Channel Not In Use" pos:[30,21]
		button DLGinUseAll images:UVBUTTON_INUSEALL width:18 height:16 enabled:false pos:[7,38]
		label DLGinUseAllLabel "All Selected Objects" pos:[30,39]
		label DLGinUseAllLabel2 "Use Channel" pos:[30,52]
		button DLGinUse images:UVBUTTON_INUSE width:18 height:16 enabled:false pos:[7,68]
		label DLGinUseLabel "Some Selected Objects" pos:[30,69]
		label DLGinUseLabel2 "Use Channel" pos:[30,82]
		button DLGbadAll images:UVBUTTON_BADALL width:18 height:16 enabled:false pos:[7,96]
		label DLGbadAllLabel "All Selected Objects" pos:[30,100]
		label DLGbadAllLabel2 "Have Bad Data" pos:[30,113]
		label DLGbadAllLabel3 "In Channel" pos:[30,126]
		button DLGbad images:UVBUTTON_BAD width:18 height:16 enabled:false pos:[7,142]
		label DLGbadLabel "Some Selected Objects" pos:[30,144]
		label DLGbadLabel2 "Have Bad Data" pos:[30,157]
		label DLGbadLabel3 "In Channel" pos:[30,170]
		checkbutton DLGuvChannel0 "Vertex Colors" tooltip:"Vertex Colors" width:18 height:16 pos:[150,8]; on DLGuvChannel0 changed state do ( uvChannelHandler 0 state )
		checkbutton DLGuvChannel1 "1" tooltip:"Channel 1" width:18 height:16 pos:[168,8]; on DLGuvChannel1 changed state do ( uvChannelHandler 1 state )
		checkbutton DLGuvChannel2 "2" tooltip:"Channel 2" width:18 height:16 pos:[186,8]; on DLGuvChannel2 changed state do ( uvChannelHandler 2 state )
		checkbutton DLGuvChannel3 "3" tooltip:"Channel 3" width:18 height:16 pos:[204,8]; on DLGuvChannel3 changed state do ( uvChannelHandler 3 state )
		checkbutton DLGuvChannel4 "4" tooltip:"Channel 4" width:18 height:16 pos:[222,8]; on DLGuvChannel4 changed state do ( uvChannelHandler 4 state )
		checkbutton DLGuvChannel5 "5" tooltip:"Channel 5" width:18 height:16 pos:[240,8]; on DLGuvChannel5 changed state do ( uvChannelHandler 5 state )
		checkbutton DLGuvChannel6 "6" tooltip:"Channel 6" width:18 height:16 pos:[258,8]; on DLGuvChannel6 changed state do ( uvChannelHandler 6 state )
		checkbutton DLGuvChannel7 "7" tooltip:"Channel 7" width:18 height:16 pos:[276,8]; on DLGuvChannel7 changed state do ( uvChannelHandler 7 state )
		checkbutton DLGuvChannel8 "8" tooltip:"Channel 8" width:18 height:16 pos:[294,8]; on DLGuvChannel8 changed state do ( uvChannelHandler 8 state )
		checkbutton DLGuvChannel9 "9" tooltip:"Channel 9" width:18 height:16 pos:[312,8]; on DLGuvChannel9 changed state do ( uvChannelHandler 9 state )
		checkbutton DLGuvChannel10 "10" tooltip:"Channel 10" width:18 height:16 pos:[150,24]; on DLGuvChannel10 changed state do ( uvChannelHandler 10 state )
		checkbutton DLGuvChannel11 "11" tooltip:"Channel 11" width:18 height:16 pos:[168,24]; on DLGuvChannel11 changed state do ( uvChannelHandler 11 state )
		checkbutton DLGuvChannel12 "12" tooltip:"Channel 12" width:18 height:16 pos:[186,24]; on DLGuvChannel12 changed state do ( uvChannelHandler 12 state )
		checkbutton DLGuvChannel13 "13" tooltip:"Channel 13" width:18 height:16 pos:[204,24]; on DLGuvChannel13 changed state do ( uvChannelHandler 13 state )
		checkbutton DLGuvChannel14 "14" tooltip:"Channel 14" width:18 height:16 pos:[222,24]; on DLGuvChannel14 changed state do ( uvChannelHandler 14 state )
		checkbutton DLGuvChannel15 "15" tooltip:"Channel 15" width:18 height:16 pos:[240,24]; on DLGuvChannel15 changed state do ( uvChannelHandler 15 state )
		checkbutton DLGuvChannel16 "16" tooltip:"Channel 16" width:18 height:16 pos:[258,24]; on DLGuvChannel16 changed state do ( uvChannelHandler 16 state )
		checkbutton DLGuvChannel17 "17" tooltip:"Channel 17" width:18 height:16 pos:[276,24]; on DLGuvChannel17 changed state do ( uvChannelHandler 17 state )
		checkbutton DLGuvChannel18 "18" tooltip:"Channel 18" width:18 height:16 pos:[294,24]; on DLGuvChannel18 changed state do ( uvChannelHandler 18 state )
		checkbutton DLGuvChannel19 "19" tooltip:"Channel 19" width:18 height:16 pos:[312,24]; on DLGuvChannel19 changed state do ( uvChannelHandler 19 state )
		checkbutton DLGuvChannel20 "20" tooltip:"Channel 20" width:18 height:16 pos:[150,40]; on DLGuvChannel20 changed state do ( uvChannelHandler 20 state )
		checkbutton DLGuvChannel21 "21" tooltip:"Channel 21" width:18 height:16 pos:[168,40]; on DLGuvChannel21 changed state do ( uvChannelHandler 21 state )
		checkbutton DLGuvChannel22 "22" tooltip:"Channel 22" width:18 height:16 pos:[186,40]; on DLGuvChannel22 changed state do ( uvChannelHandler 22 state )
		checkbutton DLGuvChannel23 "23" tooltip:"Channel 23" width:18 height:16 pos:[204,40]; on DLGuvChannel23 changed state do ( uvChannelHandler 23 state )
		checkbutton DLGuvChannel24 "24" tooltip:"Channel 24" width:18 height:16 pos:[222,40]; on DLGuvChannel24 changed state do ( uvChannelHandler 24 state )
		checkbutton DLGuvChannel25 "25" tooltip:"Channel 25" width:18 height:16 pos:[240,40]; on DLGuvChannel25 changed state do ( uvChannelHandler 25 state )
		checkbutton DLGuvChannel26 "26" tooltip:"Channel 26" width:18 height:16 pos:[258,40]; on DLGuvChannel26 changed state do ( uvChannelHandler 26 state )
		checkbutton DLGuvChannel27 "27" tooltip:"Channel 27" width:18 height:16 pos:[276,40]; on DLGuvChannel27 changed state do ( uvChannelHandler 27 state )
		checkbutton DLGuvChannel28 "28" tooltip:"Channel 28" width:18 height:16 pos:[294,40]; on DLGuvChannel28 changed state do ( uvChannelHandler 28 state )
		checkbutton DLGuvChannel29 "29" tooltip:"Channel 29" width:18 height:16 pos:[312,40]; on DLGuvChannel29 changed state do ( uvChannelHandler 29 state )
		checkbutton DLGuvChannel30 "30" tooltip:"Channel 30" width:18 height:16 pos:[150,56]; on DLGuvChannel30 changed state do ( uvChannelHandler 30 state )
		checkbutton DLGuvChannel31 "31" tooltip:"Channel 31" width:18 height:16 pos:[168,56]; on DLGuvChannel31 changed state do ( uvChannelHandler 31 state )
		checkbutton DLGuvChannel32 "32" tooltip:"Channel 32" width:18 height:16 pos:[186,56]; on DLGuvChannel32 changed state do ( uvChannelHandler 32 state )
		checkbutton DLGuvChannel33 "33" tooltip:"Channel 33" width:18 height:16 pos:[204,56]; on DLGuvChannel33 changed state do ( uvChannelHandler 33 state )
		checkbutton DLGuvChannel34 "34" tooltip:"Channel 34" width:18 height:16 pos:[222,56]; on DLGuvChannel34 changed state do ( uvChannelHandler 34 state )
		checkbutton DLGuvChannel35 "35" tooltip:"Channel 35" width:18 height:16 pos:[240,56]; on DLGuvChannel35 changed state do ( uvChannelHandler 35 state )
		checkbutton DLGuvChannel36 "36" tooltip:"Channel 36" width:18 height:16 pos:[258,56]; on DLGuvChannel36 changed state do ( uvChannelHandler 36 state )
		checkbutton DLGuvChannel37 "37" tooltip:"Channel 37" width:18 height:16 pos:[276,56]; on DLGuvChannel37 changed state do ( uvChannelHandler 37 state )
		checkbutton DLGuvChannel38 "38" tooltip:"Channel 38" width:18 height:16 pos:[294,56]; on DLGuvChannel38 changed state do ( uvChannelHandler 38 state )
		checkbutton DLGuvChannel39 "39" tooltip:"Channel 39" width:18 height:16 pos:[312,56]; on DLGuvChannel39 changed state do ( uvChannelHandler 39 state )
		checkbutton DLGuvChannel40 "40" tooltip:"Channel 40" width:18 height:16 pos:[150,72]; on DLGuvChannel40 changed state do ( uvChannelHandler 40 state )
		checkbutton DLGuvChannel41 "41" tooltip:"Channel 41" width:18 height:16 pos:[168,72]; on DLGuvChannel41 changed state do ( uvChannelHandler 41 state )
		checkbutton DLGuvChannel42 "42" tooltip:"Channel 42" width:18 height:16 pos:[186,72]; on DLGuvChannel42 changed state do ( uvChannelHandler 42 state )
		checkbutton DLGuvChannel43 "43" tooltip:"Channel 43" width:18 height:16 pos:[204,72]; on DLGuvChannel43 changed state do ( uvChannelHandler 43 state )
		checkbutton DLGuvChannel44 "44" tooltip:"Channel 44" width:18 height:16 pos:[222,72]; on DLGuvChannel44 changed state do ( uvChannelHandler 44 state )
		checkbutton DLGuvChannel45 "45" tooltip:"Channel 45" width:18 height:16 pos:[240,72]; on DLGuvChannel45 changed state do ( uvChannelHandler 45 state )
		checkbutton DLGuvChannel46 "46" tooltip:"Channel 46" width:18 height:16 pos:[258,72]; on DLGuvChannel46 changed state do ( uvChannelHandler 46 state )
		checkbutton DLGuvChannel47 "47" tooltip:"Channel 47" width:18 height:16 pos:[276,72]; on DLGuvChannel47 changed state do ( uvChannelHandler 47 state )
		checkbutton DLGuvChannel48 "48" tooltip:"Channel 48" width:18 height:16 pos:[294,72]; on DLGuvChannel48 changed state do ( uvChannelHandler 48 state )
		checkbutton DLGuvChannel49 "49" tooltip:"Channel 49" width:18 height:16 pos:[312,72]; on DLGuvChannel49 changed state do ( uvChannelHandler 49 state )
		checkbutton DLGuvChannel50 "50" tooltip:"Channel 50" width:18 height:16 pos:[150,88]; on DLGuvChannel50 changed state do ( uvChannelHandler 50 state )
		checkbutton DLGuvChannel51 "51" tooltip:"Channel 51" width:18 height:16 pos:[168,88]; on DLGuvChannel51 changed state do ( uvChannelHandler 51 state )
		checkbutton DLGuvChannel52 "52" tooltip:"Channel 52" width:18 height:16 pos:[186,88]; on DLGuvChannel52 changed state do ( uvChannelHandler 52 state )
		checkbutton DLGuvChannel53 "53" tooltip:"Channel 53" width:18 height:16 pos:[204,88]; on DLGuvChannel53 changed state do ( uvChannelHandler 53 state )
		checkbutton DLGuvChannel54 "54" tooltip:"Channel 54" width:18 height:16 pos:[222,88]; on DLGuvChannel54 changed state do ( uvChannelHandler 54 state )
		checkbutton DLGuvChannel55 "55" tooltip:"Channel 55" width:18 height:16 pos:[240,88]; on DLGuvChannel55 changed state do ( uvChannelHandler 55 state )
		checkbutton DLGuvChannel56 "56" tooltip:"Channel 56" width:18 height:16 pos:[258,88]; on DLGuvChannel56 changed state do ( uvChannelHandler 56 state )
		checkbutton DLGuvChannel57 "57" tooltip:"Channel 57" width:18 height:16 pos:[276,88]; on DLGuvChannel57 changed state do ( uvChannelHandler 57 state )
		checkbutton DLGuvChannel58 "58" tooltip:"Channel 58" width:18 height:16 pos:[294,88]; on DLGuvChannel58 changed state do ( uvChannelHandler 58 state )
		checkbutton DLGuvChannel59 "59" tooltip:"Channel 59" width:18 height:16 pos:[312,88]; on DLGuvChannel59 changed state do ( uvChannelHandler 59 state )
		checkbutton DLGuvChannel60 "60" tooltip:"Channel 60" width:18 height:16 pos:[150,104]; on DLGuvChannel60 changed state do ( uvChannelHandler 60 state )
		checkbutton DLGuvChannel61 "61" tooltip:"Channel 61" width:18 height:16 pos:[168,104]; on DLGuvChannel61 changed state do ( uvChannelHandler 61 state )
		checkbutton DLGuvChannel62 "62" tooltip:"Channel 62" width:18 height:16 pos:[186,104]; on DLGuvChannel62 changed state do ( uvChannelHandler 62 state )
		checkbutton DLGuvChannel63 "63" tooltip:"Channel 63" width:18 height:16 pos:[204,104]; on DLGuvChannel63 changed state do ( uvChannelHandler 63 state )
		checkbutton DLGuvChannel64 "64" tooltip:"Channel 64" width:18 height:16 pos:[222,104]; on DLGuvChannel64 changed state do ( uvChannelHandler 64 state )
		checkbutton DLGuvChannel65 "65" tooltip:"Channel 65" width:18 height:16 pos:[240,104]; on DLGuvChannel65 changed state do ( uvChannelHandler 65 state )
		checkbutton DLGuvChannel66 "66" tooltip:"Channel 66" width:18 height:16 pos:[258,104]; on DLGuvChannel66 changed state do ( uvChannelHandler 66 state )
		checkbutton DLGuvChannel67 "67" tooltip:"Channel 67" width:18 height:16 pos:[276,104]; on DLGuvChannel67 changed state do ( uvChannelHandler 67 state )
		checkbutton DLGuvChannel68 "68" tooltip:"Channel 68" width:18 height:16 pos:[294,104]; on DLGuvChannel68 changed state do ( uvChannelHandler 68 state )
		checkbutton DLGuvChannel69 "69" tooltip:"Channel 69" width:18 height:16 pos:[312,104]; on DLGuvChannel69 changed state do ( uvChannelHandler 69 state )
		checkbutton DLGuvChannel70 "70" tooltip:"Channel 70" width:18 height:16 pos:[150,120]; on DLGuvChannel70 changed state do ( uvChannelHandler 70 state )
		checkbutton DLGuvChannel71 "71" tooltip:"Channel 71" width:18 height:16 pos:[168,120]; on DLGuvChannel71 changed state do ( uvChannelHandler 71 state )
		checkbutton DLGuvChannel72 "72" tooltip:"Channel 72" width:18 height:16 pos:[186,120]; on DLGuvChannel72 changed state do ( uvChannelHandler 72 state )
		checkbutton DLGuvChannel73 "73" tooltip:"Channel 73" width:18 height:16 pos:[204,120]; on DLGuvChannel73 changed state do ( uvChannelHandler 73 state )
		checkbutton DLGuvChannel74 "74" tooltip:"Channel 74" width:18 height:16 pos:[222,120]; on DLGuvChannel74 changed state do ( uvChannelHandler 74 state )
		checkbutton DLGuvChannel75 "75" tooltip:"Channel 75" width:18 height:16 pos:[240,120]; on DLGuvChannel75 changed state do ( uvChannelHandler 75 state )
		checkbutton DLGuvChannel76 "76" tooltip:"Channel 76" width:18 height:16 pos:[258,120]; on DLGuvChannel76 changed state do ( uvChannelHandler 76 state )
		checkbutton DLGuvChannel77 "77" tooltip:"Channel 77" width:18 height:16 pos:[276,120]; on DLGuvChannel77 changed state do ( uvChannelHandler 77 state )
		checkbutton DLGuvChannel78 "78" tooltip:"Channel 78" width:18 height:16 pos:[294,120]; on DLGuvChannel78 changed state do ( uvChannelHandler 78 state )
		checkbutton DLGuvChannel79 "79" tooltip:"Channel 79" width:18 height:16 pos:[312,120]; on DLGuvChannel79 changed state do ( uvChannelHandler 79 state )
		checkbutton DLGuvChannel80 "80" tooltip:"Channel 80" width:18 height:16 pos:[150,136]; on DLGuvChannel80 changed state do ( uvChannelHandler 80 state )
		checkbutton DLGuvChannel81 "81" tooltip:"Channel 81" width:18 height:16 pos:[168,136]; on DLGuvChannel81 changed state do ( uvChannelHandler 81 state )
		checkbutton DLGuvChannel82 "82" tooltip:"Channel 82" width:18 height:16 pos:[186,136]; on DLGuvChannel82 changed state do ( uvChannelHandler 82 state )
		checkbutton DLGuvChannel83 "83" tooltip:"Channel 83" width:18 height:16 pos:[204,136]; on DLGuvChannel83 changed state do ( uvChannelHandler 83 state )
		checkbutton DLGuvChannel84 "84" tooltip:"Channel 84" width:18 height:16 pos:[222,136]; on DLGuvChannel84 changed state do ( uvChannelHandler 84 state )
		checkbutton DLGuvChannel85 "85" tooltip:"Channel 85" width:18 height:16 pos:[240,136]; on DLGuvChannel85 changed state do ( uvChannelHandler 85 state )
		checkbutton DLGuvChannel86 "86" tooltip:"Channel 86" width:18 height:16 pos:[258,136]; on DLGuvChannel86 changed state do ( uvChannelHandler 86 state )
		checkbutton DLGuvChannel87 "87" tooltip:"Channel 87" width:18 height:16 pos:[276,136]; on DLGuvChannel87 changed state do ( uvChannelHandler 87 state )
		checkbutton DLGuvChannel88 "88" tooltip:"Channel 88" width:18 height:16 pos:[294,136]; on DLGuvChannel88 changed state do ( uvChannelHandler 88 state )
		checkbutton DLGuvChannel89 "89" tooltip:"Channel 89" width:18 height:16 pos:[312,136]; on DLGuvChannel89 changed state do ( uvChannelHandler 89 state )
		checkbutton DLGuvChannel90 "90" tooltip:"Channel 90" width:18 height:16 pos:[150,152]; on DLGuvChannel90 changed state do ( uvChannelHandler 90 state )
		checkbutton DLGuvChannel91 "91" tooltip:"Channel 91" width:18 height:16 pos:[168,152]; on DLGuvChannel91 changed state do ( uvChannelHandler 91 state )
		checkbutton DLGuvChannel92 "92" tooltip:"Channel 92" width:18 height:16 pos:[186,152]; on DLGuvChannel92 changed state do ( uvChannelHandler 92 state )
		checkbutton DLGuvChannel93 "93" tooltip:"Channel 93" width:18 height:16 pos:[204,152]; on DLGuvChannel93 changed state do ( uvChannelHandler 93 state )
		checkbutton DLGuvChannel94 "94" tooltip:"Channel 94" width:18 height:16 pos:[222,152]; on DLGuvChannel94 changed state do ( uvChannelHandler 94 state )
		checkbutton DLGuvChannel95 "95" tooltip:"Channel 95" width:18 height:16 pos:[240,152]; on DLGuvChannel95 changed state do ( uvChannelHandler 95 state )
		checkbutton DLGuvChannel96 "96" tooltip:"Channel 96" width:18 height:16 pos:[258,152]; on DLGuvChannel96 changed state do ( uvChannelHandler 96 state )
		checkbutton DLGuvChannel97 "97" tooltip:"Channel 97" width:18 height:16 pos:[276,152]; on DLGuvChannel97 changed state do ( uvChannelHandler 97 state )
		checkbutton DLGuvChannel98 "98" tooltip:"Channel 98" width:18 height:16 pos:[294,152]; on DLGuvChannel98 changed state do ( uvChannelHandler 98 state )
		checkbutton DLGuvChannel99 "99" tooltip:"Channel 99" width:18 height:16 pos:[312,152]; on DLGuvChannel99 changed state do ( uvChannelHandler 99 state )
		button DLGall "All" pos:[150,171]; on DLGall pressed do (uvSelectedChannels = #{1..100}; updateUI())
		button DLGnone "None" pos:[180,171]; on DLGnone pressed do (uvSelectedChannels = #{}; updateUI())
		button DLGinvert "Invert" pos:[225,171]; on DLGinvert pressed do (for i in 1 to 100 do uvSelectedChannels[i] = NOT uvSelectedChannels[i]; updateUI())
		button DLGrefresh "Refresh" pos:[277,171];on DLGrefresh pressed do updateUI updateCaches:true

		group "" (
			button DLGremoveIso "Remove Isolated Map Verts" width:150 across:2
			button DLGdeleteChannels "Delete Channels" width:150
		)

		on DLGremoveIso pressed do (
			applyFunc selection removeIso
		)
		on DLGdeleteChannels pressed do (
			applyFunc selection deleteChannel
		)

-- Capture channel buttons into array
--		format "\t\t\tuvChannelButtons[100] = undefined\n\t\t\t"
--		for i in 1 to 100 do (
--			if (mod i 10) == 0 then format "\n\t\t\t"
--			format "uvChannelButtons[%] = DLGuvChannel%;" (i as string) ((i-1) as string)
--		)
--		format "\n"

		on DLGUVChannelRollout open do (
			uvSelectedChannels = #{}
			uvChannelButtons = #()

			SEL = 1
			SELTYPE = 2
			TFACES = 3
			TVERTS = 4

			uvChannelButtons[100] = undefined
			uvChannelButtons[1] = DLGuvChannel0;uvChannelButtons[2] = DLGuvChannel1;uvChannelButtons[3] = DLGuvChannel2;uvChannelButtons[4] = DLGuvChannel3;uvChannelButtons[5] = DLGuvChannel4;uvChannelButtons[6] = DLGuvChannel5;uvChannelButtons[7] = DLGuvChannel6;uvChannelButtons[8] = DLGuvChannel7;uvChannelButtons[9] = DLGuvChannel8;
			uvChannelButtons[10] = DLGuvChannel9;uvChannelButtons[11] = DLGuvChannel10;uvChannelButtons[12] = DLGuvChannel11;uvChannelButtons[13] = DLGuvChannel12;uvChannelButtons[14] = DLGuvChannel13;uvChannelButtons[15] = DLGuvChannel14;uvChannelButtons[16] = DLGuvChannel15;uvChannelButtons[17] = DLGuvChannel16;uvChannelButtons[18] = DLGuvChannel17;uvChannelButtons[19] = DLGuvChannel18;
			uvChannelButtons[20] = DLGuvChannel19;uvChannelButtons[21] = DLGuvChannel20;uvChannelButtons[22] = DLGuvChannel21;uvChannelButtons[23] = DLGuvChannel22;uvChannelButtons[24] = DLGuvChannel23;uvChannelButtons[25] = DLGuvChannel24;uvChannelButtons[26] = DLGuvChannel25;uvChannelButtons[27] = DLGuvChannel26;uvChannelButtons[28] = DLGuvChannel27;uvChannelButtons[29] = DLGuvChannel28;
			uvChannelButtons[30] = DLGuvChannel29;uvChannelButtons[31] = DLGuvChannel30;uvChannelButtons[32] = DLGuvChannel31;uvChannelButtons[33] = DLGuvChannel32;uvChannelButtons[34] = DLGuvChannel33;uvChannelButtons[35] = DLGuvChannel34;uvChannelButtons[36] = DLGuvChannel35;uvChannelButtons[37] = DLGuvChannel36;uvChannelButtons[38] = DLGuvChannel37;uvChannelButtons[39] = DLGuvChannel38;
			uvChannelButtons[40] = DLGuvChannel39;uvChannelButtons[41] = DLGuvChannel40;uvChannelButtons[42] = DLGuvChannel41;uvChannelButtons[43] = DLGuvChannel42;uvChannelButtons[44] = DLGuvChannel43;uvChannelButtons[45] = DLGuvChannel44;uvChannelButtons[46] = DLGuvChannel45;uvChannelButtons[47] = DLGuvChannel46;uvChannelButtons[48] = DLGuvChannel47;uvChannelButtons[49] = DLGuvChannel48;
			uvChannelButtons[50] = DLGuvChannel49;uvChannelButtons[51] = DLGuvChannel50;uvChannelButtons[52] = DLGuvChannel51;uvChannelButtons[53] = DLGuvChannel52;uvChannelButtons[54] = DLGuvChannel53;uvChannelButtons[55] = DLGuvChannel54;uvChannelButtons[56] = DLGuvChannel55;uvChannelButtons[57] = DLGuvChannel56;uvChannelButtons[58] = DLGuvChannel57;uvChannelButtons[59] = DLGuvChannel58;
			uvChannelButtons[60] = DLGuvChannel59;uvChannelButtons[61] = DLGuvChannel60;uvChannelButtons[62] = DLGuvChannel61;uvChannelButtons[63] = DLGuvChannel62;uvChannelButtons[64] = DLGuvChannel63;uvChannelButtons[65] = DLGuvChannel64;uvChannelButtons[66] = DLGuvChannel65;uvChannelButtons[67] = DLGuvChannel66;uvChannelButtons[68] = DLGuvChannel67;uvChannelButtons[69] = DLGuvChannel68;
			uvChannelButtons[70] = DLGuvChannel69;uvChannelButtons[71] = DLGuvChannel70;uvChannelButtons[72] = DLGuvChannel71;uvChannelButtons[73] = DLGuvChannel72;uvChannelButtons[74] = DLGuvChannel73;uvChannelButtons[75] = DLGuvChannel74;uvChannelButtons[76] = DLGuvChannel75;uvChannelButtons[77] = DLGuvChannel76;uvChannelButtons[78] = DLGuvChannel77;uvChannelButtons[79] = DLGuvChannel78;
			uvChannelButtons[80] = DLGuvChannel79;uvChannelButtons[81] = DLGuvChannel80;uvChannelButtons[82] = DLGuvChannel81;uvChannelButtons[83] = DLGuvChannel82;uvChannelButtons[84] = DLGuvChannel83;uvChannelButtons[85] = DLGuvChannel84;uvChannelButtons[86] = DLGuvChannel85;uvChannelButtons[87] = DLGuvChannel86;uvChannelButtons[88] = DLGuvChannel87;uvChannelButtons[89] = DLGuvChannel88;
			uvChannelButtons[90] = DLGuvChannel89;uvChannelButtons[91] = DLGuvChannel90;uvChannelButtons[92] = DLGuvChannel91;uvChannelButtons[93] = DLGuvChannel92;uvChannelButtons[94] = DLGuvChannel93;uvChannelButtons[95] = DLGuvChannel94;uvChannelButtons[96] = DLGuvChannel95;uvChannelButtons[97] = DLGuvChannel96;uvChannelButtons[98] = DLGuvChannel97;uvChannelButtons[99] = DLGuvChannel98;
			uvChannelButtons[100] = DLGuvChannel99;
			updateUI updateCaches:true
		)
	)

	rollout DLGmeshRollout "Edit Mesh" (
		fn supportCopyPaste = ( return false )

		fn updateUI = ()

		label DLGnothing "Nothing Here Yet"
	)

	rollout DLGMatIDRollout "Edit Material IDs" (
		fn supportCopyPaste = ( return false )

		fn updateUI = ()

		label DLGnothing "Nothing Here Yet"
	)

	rollout DLGSGRollout "Edit Smoothing Groups" (
		fn supportCopyPaste = ( return false )

		fn updateUI = ()

		label DLGnothing "Nothing Here Yet"
	)

	rollout DLGstatusRollout "Status" (
		label DLGstatus01 "" align:#left
	)
	local statusRollout = DLGstatusRollout

	-- Needed to print to status panel with it clearing itself
	fn printStatus idx str = (
		DLGstatusRollout.DLGstatus01.text = if idx == 1 then str else DLGstatusRollout.DLGstatus01.text
		DLGstatusRollout.DLGstatus02.text = if idx == 2 then str else DLGstatusRollout.DLGstatus02.text
		DLGstatusRollout.DLGstatus03.text = if idx == 3 then str else DLGstatusRollout.DLGstatus03.text
	)

	rollout DLGmainRollout "Main" (
		local meshMode
		local useCopySel
		local usePasteSel
		local baseRolloutCount
		local curRollIdx
		local oldRollIdx
		local clipBoard -- array of clips, one per meshMode

		fn updateUI = (
			DLGmainRollout.DLGmeshModes.selection = meshMode
			DLGmainRollout.DLGuseCopySel.checked = useCopySel
			DLGmainRollout.DLGusePasteSel.checked = usePasteSel
			if meshMode != oldRollIdx then (
				oldRollIdx = meshMode
				-- Delete old rollout if necessary
				if thisTool.numRolls() > baseRolloutCount then (
					thisTool.delRoll (thisTool.numRolls())
				)
				-- Add new rollout
				thisTool.addRoll meshModeRollouts[meshMode]
			)

			-- Updating sub-rollout
			local r = thisTool.getRoll (thisTool.numRolls())
			r.updateUI()
			DLGmainRollout.DLGcopy.enabled =
				DLGmainRollout.DLGpaste.enabled =
				DLGmainRollout.DLGuseCopySel.enabled =
				DLGmainRollout.DLGusePasteSel.enabled = r.supportCopyPaste()
--TODO: make this work
DLGmainRollout.DLGusePasteSel.enabled = false
		)

		fn getNewStream = (
			return case DLGmainRollout.DLGlogType.state of (
				1: newScript()
				2: (clearListener(); listener)
			)
		)

		mapped fn printStats obj aStream = (
			local objClass = classOf obj
			format "% (%, %):\n" obj.name (classOf objClass) (objClass as string) to:aStream
			case objClass of (
				editable_mesh: (
					format "\tVertex Count: %\n" obj.numverts to:aStream
					format "\tFace Count: %\n" obj.numfaces to:aStream

					-- Material IDs
					local matIDs = #()
					for i in 1 to obj.numFaces do (
						local id = getFaceMatID obj i
						if (findItem matIDs id)==0 then append matIDs id
					)
					matIDs = sort matIDs
					format "\tMaterial ID's (% used):\n\t\t" matIDs.count to:aStream
					for i in 1 to matIDs.count do (
						format "%" matIDs[i] to:aStream
						if i != matIDs.count then format ", " to:aStream
						if (mod i 10)==0 then format "\n\t\t" to:aStream
					)
					format "\n" to:aStream

					-- Map Channels
					local channels = #()
					for i in 1 to 100 do (
						if (meshOp.GetMapSupport obj (i - MAP_CHANNEL_OFFSET)) then append channels i
					)
					format "\tMap Channels (% used):\n\t\t" channels.count to:aStream
					if channels.count != 0 then (
						for i in 1 to channels.count do (
							local chan = channels[i] - MAP_CHANNEL_OFFSET
							if (IS_MAX_4) then
								format "%" (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else (chan)) to:aStream
							else
								format "%" (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else (chan-1)) to:aStream
							if i != channels.count then format ", " to:aStream
							if (mod i 10)==0 then format "\n\t\t" to:aStream
						)
					) else format "None" to:aStream
					format "\n" to:aStream
				)
			)
		)

		-- obj: object to clean
		-- badChannels: emptry array, will be filled with indicies of corrupt channels
		--				that were removed
		-- returns true if the object was cleaned, false if object wasn't valid for cleaning
		fn cleanMesh obj cleanedChannels badChannels verbose:false = (
			if	(classOf obj == editable_mesh) AND
				(obj.modifiers.count == 0) then (
				gc()

				-- Create a scratch mesh object
				local cObj = mesh numVerts:0 numFaces:0
				cObj.transform = obj.transform

				-- Verticies
				if verbose do statusRollout.DLGstatus01.text = obj.name + ": Cleaning Verticies..."
				setNumVerts cObj obj.numVerts false
				for i in 1 to obj.numVerts do (
					setVert cObj.mesh i (getVert obj.mesh i)
				)

				-- Faces
				if verbose do statusRollout.DLGstatus01.text = obj.name + ": Cleaning Faces..."
				setNumFaces cObj obj.numFaces true
				for i in 1 to obj.numFaces do (
					setFace cObj i (getFace obj i)
					setFaceSmoothGroup cObj i (getFaceSmoothGroup obj i)
					setFaceMatID cObj i (getFaceMatID obj i)
				)

				-- Edges
				if verbose do statusRollout.DLGstatus01.text = obj.name + ": Cleaning Edges..."
				for i in 1 to obj.numFaces do (
					for j in 1 to 3 do (
						setEdgeVis cObj i j (getEdgeVis obj i j)
					)
				)

				-- UV Channels
				for chan in (1 - MAP_CHANNEL_OFFSET) to (100 - MAP_CHANNEL_OFFSET) do (
					local chanStr = if (IS_MAX_4) then
						if chan == VERT_COLOR_CHANNEL then "Vertex Colors" else "Map Channel " + (chan) as string
					else
						if chan == VERT_COLOR_CHANNEL then "Vertex Colors" else "Map Channel " + (chan-1) as string
					if verbose do statusRollout.DLGstatus01.text = obj.name + ": Cleaning " + chanStr + "..."
					if (meshOp.GetMapSupport obj chan) then (
						local numTFaces = meshOp.GetNumMapFaces obj chan
						local numTVerts = meshOp.GetNumMapVerts obj chan

						meshOp.SetMapSupport cObj chan TRUE

						if NOT (chan == VERT_COLOR_CHANNEL OR chan == (VERT_COLOR_CHANNEL+1)) then (
							meshOp.SetNumMapFaces cObj chan numTFaces
						)
						meshOp.SetNumMapVerts cObj chan numTVerts

						-- Check if TFace is bad, if so, stop copying the channel
						local i = 1
						local badTFaces = false
						while (i <= numTFaces) AND NOT badTFaces do (
							local f = meshOp.GetMapFace obj chan i
							if	(f.x > numTVerts) OR (f.x < 1) OR
								(f.y > numTVerts) OR (f.y < 1) OR
								(f.z > numTVerts) OR (f.z < 1) then (
								badTFaces = true
								--format "Chan: %, FaceIdx %: Face: %\n" chan i f
							) else (
								meshOp.SetMapFace cObj chan i f
							)
							i += 1
						)

						-- If a bad TFace was found, remove the channel
						-- otherwise copy and reduce the TVerts
						if badTFaces then (
							append badChannels chan
							meshOp.FreeMapVerts cObj chan
							meshOp.FreeMapFaces cObj chan
							meshOp.SetMapSupport cObj chan false
						) else (
							meshOp.SetNumMapVerts cObj chan numTVerts
							for i in 1 to numTVerts do (
								meshOp.SetMapVert cObj chan i (meshOp.GetMapVert obj chan i)
							)
							meshOp.DeleteIsoMapVerts cObj chan
							if (meshOp.GetNumMapVerts obj chan) != (meshOp.GetNumMapVerts cObj chan) then (
								append cleanedChannels chan
							)
						)
					)
				)

				-- Grab Selections
				local vertSel = getVertSelection obj
				local edgeSel = getEdgeSelection obj
				local faceSel = getFaceSelection obj

				-- Finished
				update cObj
				--instanceReplace obj cObj
				obj.mesh = cObj.mesh
				update obj
				delete cObj

				setVertSelection obj vertSel
				setEdgeSelection obj edgeSel
				setFaceSelection obj faceSel
				update obj

				return true
			) else (
				return false
			)
		)

		fn okToCopy = (
			local flag = true

			flag = flag AND (selection.count == 1)
			flag = flag AND (classOf selection[1] == editable_mesh)
			flag = flag AND (selection[1].modifiers.count == 0)

			if NOT flag then messageBox "Selection is not valid for copy / paste." title:"Invalid Object"
			return flag
		)

		label DLGmeshModesLabel "Property To Edit:" pos:[55,15]
		dropdownlist DLGmeshModes "" items:#() width:150 pos:[145,10]

		label DLGlogTypeLabel "Print Output To:" offset:[-60,0]
		radiobuttons DLGlogType labels:#("Log File", "Listener") default:2 offset:[50,-18]
		groupBox DLGclipboardGroup "Clipboard" pos:[5,55] width:193 height:75
			button DLGcopy "Copy" width:80 pos:[15,75]
			checkbox DLGuseCopySel "Use Selection" pos:[102,78]
			button DLGpaste "Paste" width:80 pos:[15,100]
			checkbox DLGusePasteSel "Use Selection" pos:[102,103]
		groupBox DLGutilGroup "Util" pos:[203,55] width:126 height:75
			button DLGcleanMesh "Clean Mesh" width:106 pos:[213,75]
			button DLGprintStats "Print Stats" width:106 pos:[213,100]

		on DLGmeshModes selected idx do (
			if idx != meshMode then (
				meshMode = idx
				updateUI()
			)
		)

		on DLGuseCopySel changed state do ( useCopySel = state )
		on DLGusePasteSel changed state do ( usePasteSel = state )

		on DLGcopy pressed do (
			if okToCopy() do (
				local r = thisTool.getRoll (thisTool.numRolls())
				local clip = r.copyToClipboard useCopySel
				if clip != undefined then clipBoard[meshMode] = clip
			)
		)

		on DLGpaste pressed do (
			if okToCopy() do (
				local r = thisTool.getRoll (thisTool.numRolls())
				if clipBoard[meshMode] != undefined then (
					local res = r.pasteFromClipboard clipBoard[meshMode] usePasteSel
				)
			)
		)

		on DLGcleanMesh pressed do (
			local objs = selection as array
			selection = #()
			local uncleanedObjs = #()
			local cleanedObjs = #()
			local AllBadChannels = #()
			local AllCleanedChannels = #()

			createDialog	statusRollout		\
							width:300			\
							height:20			\
							style:#()
			for obj in objs do (
				statusRollout.DLGstatus01.text = obj.name
				local badChannels = #()
				local cleanedChannels = #()
				if (cleanMesh obj cleanedChannels badChannels verbose:true) then (
					append cleanedObjs obj
					append AllCleanedChannels cleanedChannels
					append AllBadChannels badChannels
				) else (
					append uncleanedObjs obj
				)
			)
			destroyDialog statusRollout
			select objs

			-- Print out stats
			--clearListener()
			if objs.count != 0 then (
				local aStream = getNewStream()
				if uncleanedObjs.count != 0 then (
					format "Objects Not Cleaned (check if modifiers are applied):\n" to:aStream
					for obj in uncleanedObjs do format "\t%\n" obj.name to:aStream
				)

				if cleanedObjs.count != 0 then (
					format "Objects Cleaned:\n" to:aStream
					for i in 1 to cleanedObjs.count do (
						local obj = cleanedObjs[i]

						format "\t%\n" obj.name to:aStream

						local channels = #()
						for i in 1 to 100 do (
							if (meshOp.GetMapSupport obj (i - MAP_CHANNEL_OFFSET)) then append channels (i - MAP_CHANNEL_OFFSET)
						)
						format "\t\tMap Channels Used: " to:aStream
						if channels.count != 0 then (
							for chan in channels do (
								if (IS_MAX_4) then
									format "%, " (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else ("#" + (chan) as string)) to:aStream
								else
									format "%, " (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else ("#" + (chan-1) as string)) to:aStream
							)
						) else format "None" to:aStream
						format "\n" to:aStream

						format "\t\tCleaned Map Channels: " to:aStream
						if AllCleanedChannels[i].count != 0 then (
							for chan in AllCleanedChannels[i] do (
								if (IS_MAX_4) then
									format "%, " (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else ("#" + (chan) as string)) to:aStream
								else
									format "%, " (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else ("#" + (chan-1) as string)) to:aStream
							)
						) else format "None" to:aStream
						format "\n" to:aStream

						format "\t\tCorrupt Map Channels Removed: " to:aStream
						if AllBadChannels[i].count != 0 then (
							for chan in AllBadChannels[i] do (
								if (IS_MAX_4) then
									format "%, " (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else ("#" + (chan) as string)) to:aStream
								else
									format "%, " (if (chan==VERT_COLOR_CHANNEL) then "Vertex Colors" else ("#" + (chan-1) as string)) to:aStream
							)
						) else format "None" to:aStream
						format "\n" to:aStream
					)
				)
			)

			updateUI()
		)

		on DLGprintStats pressed do (
			if selection.count != 0 do printStats selection (getNewStream())
			updateUI()
		)

		on DLGmainRollout open do (
			baseRolloutCount = 2
			oldRollIdx = 0
			meshMode = 1
--			meshModeNames = #("UV Channels","Mesh","Material IDs","Smoothing Groups")
			meshModeNames = #("UV Channels")
			meshModeRollouts = #(DLGuvChannelRollout, DLGmeshRollout, DLGMatIDrollout, DLGSGRollout)
			useCopySel = true
			usePasteSel = false
			clipBoard = #(); clipBoard[meshModeNames.count] = undefined

			DLGmainRollout.DLGmeshModes.items = meshModeNames
			updateUI()
		)
	)

	thisTool.addRoll #(DLGaboutRollout, DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
