macroScript MorpherMan
category:"fooTOOLS"
buttontext:"MorpherMan"
tooltip:"MorpherMan - Morpher Key Thingy"
icon:#("fooTOOLS-Icons",18)
(

------------------------------------------------------------------------------------------
-- Contents:
--		MorpherMan - Description: Morph Key Thingy
--
-- Requires:
--		jbFunctions.ms
--		ish_MorpherCtrl.dlx
--		CtrlLib.dlx (r3.1 only)
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("ish_MorpherCtrl",0), #("ctrlLib",2.2) )
	)
) then (

	local thisTool = BFDtool	toolName:"MorpherMan"		\
								author:"John Burnett"		\
								createDate:[2000,06,14]		\
								modifyDate:[2001,06,24]		\
								version:2					\
								defFloaterSize:[330,602]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:true

	struct morphChannel (
		index,
		chanName
	)

	local UpdateUIAll

	local NUMCHANNELS = 100
	local TANTYPES = #(#smooth,#linear,#step,#fast,#slow,#custom)

	local curObj, curMod
	local targObj, targMod
	local curChannels = #()
	local targChannels = #()

	fn pickMorpherFilter obj = (
		for i in 1 to obj.modifiers.count do (
			if (IsValidMorpherMod obj.modifiers[i]) do return true
		)
		return false
	)

	fn getMorpher obj = (
		local morphers = for m in obj.modifiers where (IsValidMorpherMod m) collect m

--TODO: case of more than one morpher applied to object
--		if morphers.count >= 1 do (
--		)

		return morphers[1]
	)

	fn validState aObj aMod = (
		return (
			if	(objectExists aObj) AND
				(superClassOf aMod == modifier) AND
				(IsValidMorpherMod aMod) then true else false
		)
	)

	fn getActiveChannels m = (
		for i in 1 to NUMCHANNELS where (WM3_MC_HasData m i) collect (
			(morphChannel chanName:(WM3_MC_GetName m i) index:i)
		)
	)

	rollout DLGaboutRollout "About" (
		button DLGhelp "Help"
		label DLGAbout01 "" offset:[0,5]
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGhelp pressed do (
			local helpStr = "Help Goes Here"
			messageBox helpStr title:"MorpherMan Help"
		)

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do ( thisTool.closeTool() )
	)

	rollout DLGmainRollout "Main Rollout" (
		local lockTypes
		local curInType, curOutType

		fn updateUI = (
			local R = DLGmainRollout

			if (validState curObj curMod) then (
				R.DLGcurObj.text = snipString curObj.name 25
				R.DLGcurMod.text =	"[" +
									((findItem curObj.modifiers curMod) as string) +
									"] " + (snipString curMod.name 25)
			) else (
				R.DLGcurObj.text = R.DLGcurMod.text = "-- none --"
			)

			R.DLGlockTypes.checked = lockTypes
			R.DLGinType.selection = curInType
			R.DLGoutType.selection = curOutType
			R.DLGoutType.enabled = NOT lockTypes

			R.DLGaddkeyAll.enabled =
				R.DLGsetAllTangents.enabled = validState curObj curMod
		)

		fn setMorpherKeyTan mmod chan inType outType = (
			if	(WM3_MC_HasData mmod chan) AND
				(mmod[chan].controller != undefined) AND
				(classOf mmod[chan].controller == bezier_float) do (

				local mCtrl = mmod[chan].controller
				local kIdx = getKeyIndex mCtrl currentTime

				if kIdx == 0 do return undefined

				local k = getKey mCtrl kIdx

				k.inTangentType = inType
				k.outTangentType = outType

				return k
			)
			return undefined
		)

		fn addMorpherKey mmod chan inType:#smooth outType:#smooth = (
			if	(WM3_MC_HasData mmod chan) AND
				(mmod[chan].controller != undefined) AND
				(classOf mmod[chan].controller == bezier_float) do (

				local mCtrl = mmod[chan].controller
				local kIdx = getKeyIndex mCtrl currentTime
				local k = if kIdx == 0 then (
					addNewKey mCtrl currentTime
				) else (
					getKey mCtrl kIdx
				)

				k.inTangentType = inType
				k.outTangentType = outType

				WM3_RefreshChannelListUI mmod

				return k
			)
			return undefined
		)

		groupBox DLGmorpherGroup "Current Morpher" pos:[3,1] width:127 height:120
			pickButton DLGpickMorpher "Pick Current Morpher" filter:pickMorpherFilter pos:[10,18] width:112 height:24
			label DLGcurObjLabel "Object:" pos:[12,48]
			label DLGcurObj "foo" pos:[60,63]
			label DLGcurModLabel "Modifier:" pos:[12,85]
			label DLGcurMod "bar" pos:[60,100]

		groupBox DLGsetKeysGroup "Set Channel Keys" pos:[136,1] width:162 height:120
			dropDownList DLGinType "In Tangent:" pos:[143,19] width:63 height:40 items:#("Smooth","Linear","Step","Fast","Slow","Custom")
			checkButton DLGlockTypes "L" pos:[209,40] width:16 height:16 toolTip:"Lock Tangent Types"
			dropDownList DLGoutType "Out Tangent:" pos:[229,19] width:63 height:40 items:#("Smooth","Linear","Step","Fast","Slow","Custom")
			button DLGsetAllTangents "Set All Tangents" pos:[143,64] width:148 height:24
			button DLGaddkeyAll "Key All Channels" pos:[143,92] width:148 height:24

		on DLGpickMorpher picked obj do (
			curMod = getMorpher obj
			if curMod != undefined do curObj = obj
			curChannels = getActiveChannels curMod

			updateUIAll()
		)

		on DLGlockTypes changed state do (
			lockTypes = state
			if lockTypes do curOutType = curInType
			updateUIAll()
		)
		on DLGinType selected idx do (
			curInType = idx
			if lockTypes do curOutType = idx
			updateUIAll()
		)
		on DLGoutType selected idx do ( curOutType = idx; updateUIAll() )

		on DLGsetAllTangents pressed do (
			if (validState curObj curMod) then (
				for i in 1 to NUMCHANNELS do (
					setMorpherKeyTan curMod i TANTYPES[curInType] TANTYPES[curOutType]
				)
			)
			updateUIAll()
		)

		on DLGaddKeyAll pressed do (
			if (validState curObj curMod) then (
				for i in 1 to NUMCHANNELS do (
					addMorpherKey curMod i inType:TANTYPES[curInType] outType:TANTYPES[curOutType]
				)
			)
			updateUIAll()
		)

		on DLGmainRollout open do (
			curObj = curMod = undefined
			lockTypes = true
			curInType = curOutType = 1
		)
	)

	rollout DLGcopyChannelsRollout "Copy Channels" (
		fn updateUI = (
			local R = DLGcopyChannelsRollout

			local validCur = validState curObj curMod
			local validTarg = validState targObj targMod

			if (validCur) then (
				R.DLGcurObj.text = snipString curObj.name 25
				R.DLGcurMod.text =	"[" +
									((findItem curObj.modifiers curMod) as string) +
									"] " + (snipString curMod.name 25)
			) else (
				R.DLGcurObj.text = R.DLGcurMod.text = "-- none --"
			)

			if (validTarg) then (
				R.DLGtargObj.text = snipString targObj.name 25
				R.DLGtargMod.text =	"[" +
									((findItem targObj.modifiers targMod) as string) +
									"] " + (snipString targMod.name 25)
			) else (
				R.DLGtargObj.text = R.DLGtargMod.text = "-- none --"
			)

			local chanNames
			chanNames = for chan in curChannels collect (if chan != undefined then chan.chanName else "------------------------------------------------------------")
			R.DLGcurChannels.items = chanNames
			chanNames = for chan in targChannels collect (if chan != undefined then chan.chanName else "------------------------------------------------------------")
			R.DLGtargChannels.items = chanNames

			R.DLGcopyAnimation.enabled = 	validCur AND
											validTarg AND
											(curChannels.count != 0) AND
											(targChannels.count != 0)
		)

		groupBox DLGcurMorpherGroup "Source Morpher" width:127 height:120 pos:[6,3]
			pickButton DLGpickCur "Pick Source Morpher" filter:pickMorpherFilter width:112 height:24 pos:[13,20]
			label DLGcurObjLabel "Object:" pos:[15,50]
			label DLGcurObj "foo" pos:[63,65]
			label DLGcurModLabel "Modifier:" pos:[15,87]
			label DLGcurMod "bar" pos:[63,102]
		listBox DLGcurChannels "Source Channels:" width:124 height:10 pos:[6,130]
			button DLGcurUp "/\\" width:15 height:24 pos:[131,148]
			button DLGcurDown "\\/" width:15 height:24 pos:[131,257]
			button DLGcurAdd "Add Null" width:60 height:20 pos:[7,287]
			button DLGcurDel "Del Sel" width:60 height:20 pos:[69,287]

		groupBox DLGtargMorpherGroup "Target Morpher" width:127 height:120 pos:[171,3]
			pickButton DLGpickTarg "Pick Target Morpher" filter:pickMorpherFilter width:112 height:24 pos:[178,20]
			label DLGtargObjLabel "Object:" pos:[180,50]
			label DLGtargObj "foo" pos:[228,64]
			label DLGtargModLabel "Modifier:" pos:[180,87]
			label DLGtargMod "bar" pos:[228,102]
		listBox DLGtargChannels "Target Channels:" width:124 height:10 pos:[173,130]
			button DLGtargUp "/\\" width:15 height:24 pos:[158,148]
			button DLGtargDown "\\/" width:15 height:24 pos:[158,257]
			button DLGtargAdd "Add Null" width:60 height:20 pos:[174,287]
			button DLGtargDel "Del Sel" width:60 height:20 pos:[236,287]

		button DLGsyncNames "<match>" width:44 pos:[130,207] enabled:false

		checkbox DLGdelExistingAnim "Delete Existing Animation" checked:true pos:[80,315]
		button DLGcopyAnimation "-> Copy Animation ->" width:120 height:30 pos:[90,335]

		on DLGpickCur picked obj do (
			curMod = getMorpher obj
			if curMod != undefined do curObj = obj
			curChannels = getActiveChannels curMod

			updateUIAll()
		)

		on DLGpickTarg picked obj do (
			targMod = getMorpher obj
			if targMod != undefined do targObj = obj
			targChannels = getActiveChannels targMod

			updateUI()
		)

		on DLGcurUp pressed do (
			if (validListboxSel DLGcurChannels) then (
				local idx = DLGcurChannels.selection
				if (idx >= 2) then (
					swap curChannels[idx] curChannels[idx-1]
					DLGcurChannels.selection -= 1
				)
			)
			updateUI()
		)
		on DLGcurDown pressed do (
			if (validListboxSel DLGcurChannels) then (
				local idx = DLGcurChannels.selection
				if (idx <= (curChannels.count-1)) then (
					swap curChannels[idx] curChannels[idx+1]
					DLGcurChannels.selection += 1
				)
			)
			updateUI()
		)
		on DLGcurAdd pressed do (
			if (validListboxSel DLGcurChannels) then (
				insertAfter curChannels undefined DLGcurChannels.selection
			)
			updateUI()
		)
		on DLGcurDel pressed do (
			if (validListboxSel DLGcurChannels) then (
				deleteItem curChannels DLGcurChannels.selection
			)
			updateUI()
		)

		on DLGtargUp pressed do (
			if (validListboxSel DLGtargChannels) then (
				local idx = DLGtargChannels.selection
				if (idx >= 2) then (
					swap targChannels[idx] targChannels[idx-1]
					DLGtargChannels.selection -= 1
				)
			)
			updateUI()
		)
		on DLGtargDown pressed do (
			if (validListboxSel DLGtargChannels) then (
				local idx = DLGtargChannels.selection
				if (idx <= (targChannels.count-1)) then (
					swap targChannels[idx] targChannels[idx+1]
					DLGtargChannels.selection += 1
				)
			)
			updateUI()
		)
		on DLGtargAdd pressed do (
			if (validListboxSel DLGtargChannels) then (
				insertAfter targChannels undefined DLGtargChannels.selection
			)
			updateUI()
		)
		on DLGtargDel pressed do (
			if (validListboxSel DLGtargChannels) then (
				deleteItem targChannels DLGtargChannels.selection
			)
			updateUI()
		)

		on DLGsyncNames pressed do (
		)

		on DLGcopyAnimation pressed do (
			if DLGdelExistingAnim.checked do (
				for i in 1 to NUMCHANNELS do (
					if targMod[i].controller != undefined do (
						targMod[i].controller = bezier_float()
						deleteKeys targMod[i].keys #allKeys
					)
				)
			)

			for i in 1 to curChannels.count do (
				if (curChannels[i] != undefined) AND (targChannels[i] != undefined) then (
					targMod[targChannels[i].index].controller = copy curMod[curChannels[i].index].controller
				)
			)
			updateUI()
		)

		on DLGcopyChannelsRollout open do (
			targObj = targMod = undefined
		)
	)

	fn UpdateUIAll = (
		DLGmainRollout.updateUI()
		DLGcopyChannelsRollout.updateUI()
	)

	thisTool.addRoll #(DLGaboutRollout,DLGmainRollout,DLGcopyChannelsRollout) rolledUp:#(true,false,false)

	thisTool.openTool thisTool
	updateUIAll()
)
)
