macroScript ParticleTracker
category:"fooTOOLS"
buttontext:"ParticleTracker"
tooltip:"ParticleTracker - Track particles in a particle system"
icon:#("fooTOOLS-Icons",20)
(

------------------------------------------------------------------------------------------
-- Contents:
--		ParticleTracker - Description: Track particles in a particle system
--
-- Requires:
--		jbFunctions.ms
--		jbLib.dlx
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("jbLib",1) )
	)
) then (

	local thisTool = BFDtool	toolName:"ParticleTracker"	\
								author:"John Burnett"		\
								createDate:[1999,08,11]		\
								modifyDate:[2001,05,21]		\
								version:1					\
								defFloaterSize:[250,743]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:true

	local posCache = #()
	local ageCache = #()

	local timeRange = (interval animationRange.start animationRange.end)
	local nthFrame = 1.0
	local forceDeathKeys = false

	local sourceParts = #()
	local trackerObjs = #()

	local useBounds = false
	local boundingBoxes = #()

	local dupTracker = true
	local dupType = 2
	local groupTrackers = true

	local rotType = 1
	local flipAxis = true

	local tumbleAmount = 1.0
	local tumbleSpeedMin = 5.0
	local tumbleSpeedMax = 10.0

	local queueLoc = [0,0,0]


	rollout DLGaboutRollout "About" (
		button DLGhelp "Help"
		label DLGAbout01 "" offset:[0,5]
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGhelp pressed do (
			local helpStr = "Help Goes Here"
			messageBox helpStr title:"ParticleTracker Help"
		)

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do ( thisTool.closeTool() )
	)

	rollout DLGmainRollout "Main Rollout" (
		fn UpdateUI = (
			local R = DLGmainRollout
			R.DLGstartTime.value = timeRange.start
			R.DLGendTime.value = timeRange.end
			R.DLGnthFrame.value = nthFrame
			R.DLGforceDeathKeys.checked = forceDeathKeys
			R.DLGtrack.enabled = (sourceParts.count != 0) AND (trackerObjs.count != 0)
		)

		fn inBounds pnt obj = (
			if	(pnt.x >= obj.min.x) AND (pnt.x <= obj.max.x) AND
				(pnt.y >= obj.min.y) AND (pnt.y <= obj.max.y) AND
				(pnt.z >= obj.min.z) AND (pnt.z <= obj.max.z) then TRUE else FALSE
		)

		fn buildCaches sourcePartIdx = (
			progressStart "Getting Particle Animation..."
			local DEAD = -1f
			--Cache of particle info: cache[particle][time]
			posCache = #()
			ageCache = #()

			local sourcePart = sourceParts[sourcePartIdx]
			local numParts = particleCount sourcePart

			for i in 1 to numParts do (
				posCache[i] = #()
				ageCache[i] = #()
				if useBounds then (
					for t in timeRange.start to timeRange.end do (
						local tf = t as float/ticksPerFrame
						posCache[i][tf] = at time t (particlePos sourcePart i)
						if posCache[i][tf] == undefined then posCache[i][tf] = queueLoc
						local cont = false
						for obj in boundingBoxes do (
							if (cont = inBounds posCache[i][tf] obj) then exit
						)
						if cont then (
							ageCache[i][tf] = at time t (particleAge sourcePart i)
							if ageCache[i][tf] == undefined then ageCache[i][tf] = DEAD
						) else (
							posCache[i][tf] = queueLoc
							ageCache[i][tf] = DEAD
						)
					)
					--This is WRONG and should change! (be wary of shitty superspray and family,
					--as sampling age out of current timerange will assert!)
					posCache[i][(timeRange.start as float/ticksPerFrame)-1] = queueLoc
					ageCache[i][(timeRange.start as float/ticksPerFrame)-1] = DEAD
					posCache[i][(timeRange.end as float/ticksPerFrame)+1] = queueLoc
					ageCache[i][(timeRange.end as float/ticksPerFrame)+1] = DEAD
				) else (
					for t in timeRange.start to timeRange.end do (
						local tf = t as float/ticksPerFrame
						posCache[i][tf] = at time t (particlePos sourcePart i)
						if posCache[i][tf] == undefined then posCache[i][tf] = queueLoc
						ageCache[i][tf] = at time t (particleAge sourcePart i)
						if ageCache[i][tf] == undefined then ageCache[i][tf] = DEAD
					)
					--This is WRONG and should change! (be wary of shitty superspray and family,
					--as sampling age out of current timerange will assert!)
					posCache[i][(timeRange.start as float/ticksPerFrame)-1] = queueLoc
					ageCache[i][(timeRange.start as float/ticksPerFrame)-1] = DEAD
					posCache[i][(timeRange.end as float/ticksPerFrame)+1] = queueLoc
					ageCache[i][(timeRange.end as float/ticksPerFrame)+1] = DEAD
				)
				progressUpdate (i/numParts as float*100)
			)
			progressEnd()
		)

		-- add a key to obj at time t, using sourcePart's particle number idx
		fn addPTrackKey obj sourcePart idx t = (
			local tf = t as float/ticksPerFrame
			local pos = posCache[idx][tf]
			local k = addNewKey obj.pos.controller t
			k.value = pos
			k.inTangentType = k.outTangentType = #linear
			case rotType of (
				1: ()
				2: (
					--local m = obj.transform
					--m.row1 = -1 * normalize ((at time (t-1) obj.pos)-pos)
					--m.row2 = normalize (cross [0,0,1] m.row1)
					--m.row3 = cross m.row1 m.row2
					--obj.rotation = m as quat
					animate on at time t (
						obj.dir = normalize ((posCache[idx][tf-1]) - pos)
						if flipAxis then obj.dir *= -1
					)
				)
				3: (
					local ang = #()
					for j in 1 to 3 do (
						seed idx
						--local delta = if tumbleSpeedScale then ( length (posCache[idx][tf-1] - pos) / 10 ) else ( 1.0 )
						--local offset = random 1000 -1000
						--local n = noise3( pos * (random tumbleSpeedMin tumbleSpeedMax) * 0.001 * delta )
						--local speed = if tumbleSpeedScale then ( length (posCache[idx][tf-1] - pos) / 10 ) else ( random tumbleSpeedMin tumbleSpeedMax )
						local speed = random tumbleSpeedMin tumbleSpeedMax
						local n = noise3( pos * speed * 0.001 )
						ang[j] = n * tumbleAmount * 360
					)
					ang = eulerAngles ang[1] ang[2] ang[3]
					animate on at time t in coordsys obj obj.rotation = ang as quat
				)
				default: ()
			)
		)

		fn trackParticles = (
			local DEAD = -1f

			for sourcePartIdx in 1 to sourceParts.count do (
				local sourcePart = sourceParts[sourcePartIdx]
				local numFrames = (timeRange.end - timeRange.start) as float
				numFrames = (numFrames / ticksPerFrame) as integer

				local numParts = particleCount sourcePart
				local trackers = #()
				if dupTracker then (
					for i in 1 to numParts do (
						local srcObj = trackerObjs[(random 1 trackerObjs.count)]
						local dupObj
						case dupType of (
							1: dupObj = copy srcObj
							2: dupObj = if (isParticleSystem srcObj) then copy srcObj else instance srcObj
							3: dupObj = if (isParticleSystem srcObj) then copy srcObj else reference srcObj
						)
						dupObj.name = uniqueName (sourcePart.name + "_" + srcObj.name + "_Tracker")
						append trackers dupObj
					)
				) else (
					trackers = copy trackerObjs #nomap
				)
				for obj in trackers do (
					obj.transform.controller = prs()
					obj.pos.controller = bezier_position()
					deleteKeys obj.pos.controller #allKeys
					if (rotType==2) OR (rotType==3) then (
						obj.rotation.controller = tcb_rotation()
						deleteKeys obj.rotation.controller #allKeys
					)
				)

				buildCaches sourcePartIdx

				progressStart ("Tracking over " + (numFrames as string) + " Frames...")
				for t in timeRange.start to timeRange.end do (
					local tf = t as float/ticksPerFrame
					if (mod (t-timeRange.start) nthFrame) == 0 then (
						for trackerIdx in 1 to trackers.count do (
							addPTrackKey trackers[trackerIdx] sourcePart trackerIdx t
						)
					)
					if forceDeathKeys then (
						for i in 1 to trackers.count do (
							local curAge = ageCache[i][tf]
							local oldAge = ageCache[i][tf-1]
							local nextAge = ageCache[i][tf+1]
							--if NOT (totally dead) AND
							--(about to die) OR
							--(just born) THEN
							if  NOT ((curAge == DEAD) AND (nextAge == DEAD)) AND
								( (curAge != DEAD) AND ((nextAge == DEAD) OR (curAge > nextAge)) ) OR
								( ((oldAge != DEAD) AND (curAge < oldAge)) OR ((curAge != DEAD) AND (oldAge == DEAD)) ) then (
									addPTrackKey trackers[i] sourcePart i t
							)
						)
					)
					if NOT (progressUpdate (((t-timeRange.start) as float / (timeRange.end-timeRange.start) as float) * 100)) then (
						exit
					)
				)
				if groupTrackers then (
					group trackers name:(uniqueName ("G_" + sourcePart.name + "_Trackers"))
				)

				progressEnd()
			)
		)

		button DLGtrack "Track" width:110 height:30
		group "Sampling" (
			spinner DLGstartTime "Start" range:[-105214,105213,0] type:#integer fieldWidth:50 across:2
			spinner DLGendTime "End" range:[-105213,105214,100] type:#integer fieldWidth:50
			spinner DLGnthFrame "Every Nth Frame" range:[1,999999,1] type:#integer fieldWidth:50 offset:[-1,0]
			checkbox DLGforceDeathKeys "Force Keys on Particle Birth/Death"
		)

		on DLGstartTime changed val do ( timeRange.start = val; UpdateUI() )
		on DLGendTime changed val do ( timeRange.end = val; UpdateUI() )
		on DLGnthFrame changed val do (
			nthFrame = val
			if nthFrame == 1 then forceDeathKeys = false else forceDeathKeys = true
			UpdateUI()
		)
		on DLGforceDeathKeys changed state do (
			local cont = true
			if state AND (nthFrame == 1) then (
				local str = "Turning on this option is unnecessary when sampling
on every frame, and will slow down tracking considerably.

Are you sure you want to do this?"
				cont = queryBox str title:"Warning!"
				forceDeathKeys = cont
			) else (
				forceDeathKeys = state
			)
			UpdateUI()
		)

		on DLGtrack pressed do ( trackParticles() )

		on DLGmainRollout open do (
			UpdateUI()
		)

		on DLGmainRollout close do (
			try (DLGptrackFloaterButton.checked = false) catch ()
		)
	)

--OK
	rollout DLGobjectsRollout "Tracker Objects" (
		fn UpdateUI = (
			local R = DLGobjectsRollout

			trimInvalidObjects sourceParts
			R.DLGsourcePartsList.items = for i in 1 to sourceParts.count collect
								( (i as string) + ": " + sourceParts[i].name )

			trimInvalidObjects trackerObjs
			R.DLGtrackerObjsList.items = for i in 1 to trackerObjs.count collect
								( (i as string) + ": " + trackerObjs[i].name )
		)

		group "Source Particle(s)" (
			pickbutton DLGaddPickSourcePart "Add Pick" filter:isParticleSystem width:50 height:16 align:#left offset:[0,-1]
			button DLGaddSelSourcePart "Add Sel" width:50 height:16 align:#left offset:[0,-4]
			button DLGremoveSourcePart "Clear" width:50 height:16 align:#left offset:[0,-4]
			button DLGremoveAllSourceParts "Clear All" width:50 height:16 align:#left offset:[0,-4]
			listbox DLGsourcePartsList height:5 width:145 offset:[55,-75]
		)
		group "Tracker Object(s)" (
			pickbutton DLGaddPickTrackerObj "Add Pick" width:50 height:16 align:#left offset:[0,-1]
			button DLGaddSelTrackerObj "Add Sel" width:50 height:16 align:#left offset:[0,-4]
			button DLGremoveTrackerObj "Clear" width:50 height:16 align:#left offset:[0,-4]
			button DLGremoveAllTrackerObjs "Clear All" width:50 height:16 align:#left offset:[0,-4]
			listbox DLGtrackerObjsList height:5 width:145 offset:[55,-75]
		)

		on DLGaddPickSourcePart picked obj do (
			if (findItem sourceParts obj)==0 then append sourceParts obj
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGaddSelSourcePart pressed do (
			for obj in (selection as array) do (
				if (isParticleSystem obj) AND (findItem sourceParts obj)==0 then (
					append sourceParts obj
				)
			)
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGremoveSourcePart pressed do (
			try (deleteItem sourceParts DLGsourcePartsList.selection) catch ()
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGremoveAllSourceParts pressed do (
			sourceParts = #()
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)

		on DLGaddPickTrackerObj picked obj do (
			if (findItem trackerObjs obj)==0 then append trackerObjs obj
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGaddSelTrackerObj pressed do (
			for obj in (selection as array) do (
				if (findItem trackerObjs obj)==0 then (
					append trackerObjs obj
				)
			)
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGremoveTrackerObj pressed do (
			try (deleteItem trackerObjs DLGpartTrackerList.selection) catch ()
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGremoveAllTrackerObjs pressed do (
			trackerObjs = #()
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)

		on DLGobjectsRollout open do (
			UpdateUI()
		)
	)

--OK
	rollout DLGboundingBoxesRollout "Bounding Boxes" (
		fn UpdateUI = (
			local R = DLGboundingBoxesRollout
			R.DLGuseBounds.checked = useBounds

			trimInvalidObjects boundingBoxes
			R.DLGboundingBoxList.items = for i in 1 to boundingBoxes.count collect
								( (i as string) + ": " + boundingBoxes[i].name )

			R.DLGaddPickBoundingBox.enabled =
				R.DLGaddSelBoundingBoxes.enabled =
				R.DLGremoveBoundingBox.enabled =
				R.DLGremoveAllBoundingBoxes.enabled =
				R.DLGboundingBoxList.enabled = useBounds
		)

		checkbox DLGuseBounds "Use Bounding Boxes" align:#left
		group "Bounding Box(es)" (
			pickbutton DLGaddPickBoundingBox "Add Pick" width:50 height:16 align:#left offset:[0,-1]
			button DLGaddSelBoundingBoxes "Add Sel" width:50 height:16 align:#left offset:[0,-4]
			button DLGremoveBoundingBox "Clear" width:50 height:16 align:#left offset:[0,-4]
			button DLGremoveAllBoundingBoxes "Clear All" width:50 height:16 align:#left offset:[0,-4]
			listbox DLGboundingBoxList height:5 width:145 offset:[55,-75]
		)

		on DLGuseBounds changed state do ( useBounds = state; UpdateUI() )

		on DLGaddPickBoundingBox picked obj do (
			if (findItem boundingBoxes obj)==0 then append boundingBoxes obj
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGaddSelBoundingBoxes pressed do (
			for obj in selection do (
				if (findItem boundingBoxes obj)==0 then (
					append boundingBoxes obj
				)
			)
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGremoveBoundingBox pressed do (
			try (deleteItem boundingBoxes DLGboundingBoxList.selection) catch ()
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)
		on DLGremoveAllBoundingBoxes pressed do (
			boundingBoxes = #()
			UpdateUI()
			DLGmainRollout.UpdateUI()
		)

		on DLGboundingBoxesRollout open do (
			UpdateUI()
		)
	)

--OK
	rollout DLGoptionsRollout "Tracker Options" (
		fn UpdateUI = (
			R = DLGoptionsRollout

			R.DLGdupTracker.checked =
				R.DLGdupType.enabled =
				R.DLGgroupTrackers.enabled = dupTracker
			R.DLGdupType.state = dupType
			R.DLGgroupTrackers.checked = groupTrackers

			R.DLGrotType.state = rotType
			R.DLGflipAxis.checked = flipAxis
			R.DLGtumbleAmount.value = tumbleAmount
			R.DLGtumbleSpeedMin.value = tumbleSpeedMin
			R.DLGtumbleSpeedMax.value = tumbleSpeedMax
			--R.DLGtumbleSpeedScale.checked = tumbleSpeedScale
			R.DLGflipAxis.enabled = (rotType==2)
			R.DLGtumbleAmount.enabled =
				--R.DLGtumbleSpeedScale.enabled =
				R.DLGtumbleSpeedMin.enabled =
				R.DLGtumbleSpeedMax.enabled = (rotType==3)

			R.DLGqueueLocX.value = queueLoc.x
			R.DLGqueueLocY.value = queueLoc.y
			R.DLGqueueLocZ.value = queueLoc.z
		)

		group "Duplication" (
			checkbox DLGdupTracker "Duplicate Trackers" align:#left
			radiobuttons DLGdupType labels:#("Copy","Instance","Reference") offset:[9,0]
			checkbox DLGgroupTrackers "Group Trackers" offset:[16,0]
		)

		group "Orientation" (
			radiobuttons DLGrotType labels:#("Constant","Align Trackers To Z Axis","Random Tumble") offset:[-34,0]
			checkbox DLGflipAxis "Flip" offset:[140,-35]
			spinner DLGtumbleAmount "Tumble Amount" range:[0,1.0,0] scale:0.01 fieldWidth:50 offset:[0,11]
			spinner DLGtumbleSpeedMin "Tumble Speed Min" range:[0,999999,0] fieldWidth:50 offset:[0,-2]
			spinner DLGtumbleSpeedMax "Tumble Speed Max" range:[0,999999,0] fieldWidth:50 offset:[0,-2]
			--checkbox DLGtumbleSpeedScale "Scale Tumble With Speed" offset:[53,-2]
		)
		label DLGpartQueueLocLabel "Trackers Queue Location:" align:#left
		pickbutton DLGpickQueueLoc "Pick" width:35 height:16 offset:[-65,0]
		spinner DLGqueueLocX "" range:[-999999,999999,0] fieldWidth:37 offset:[-96,-21]
		spinner DLGqueueLocY "" range:[-999999,999999,0] fieldWidth:37 offset:[-48,-21]
		spinner DLGqueueLocZ "" range:[-999999,999999,0] fieldWidth:37 offset:[0,-21]

		on DLGdupTracker changed state do ( dupTracker = state; UpdateUI() )
		on DLGdupType changed state do ( dupType = state; UpdateUI() )
		on DLGgroupTrackers changed state do ( groupTrackers = state; UpdateUI() )

		on DLGrotType changed state do ( rotType = state; UpdateUI() )
		on DLGflipAxis changed state do ( flipAxis = state; UpdateUI() )
		on DLGtumbleAmount changed val do ( tumbleAmount = val; UpdateUI() )
		on DLGtumbleSpeedMin changed val do ( tumbleSpeedMin = val; UpdateUI() )
		on DLGtumbleSpeedMax changed val do ( tumbleSpeedMax = val; UpdateUI() )
		--on DLGtumbleSpeedScale changed state do ( tumbleSpeedScale = state; UpdateUI() )

		on DLGpickQueueLoc picked obj do ( queueLoc.x = obj.pos.x; queueLoc.y = obj.pos.y; queueLoc.z = obj.pos.z; UpdateUI() )
		on DLGqueueLocX changed val do ( queueLoc.x = val; UpdateUI() )
		on DLGqueueLocY changed val do ( queueLoc.y = val; UpdateUI() )
		on DLGqueueLocZ changed val do ( queueLoc.z = val; UpdateUI() )

		on DLGoptionsRollout open do (
			UpdateUI()
		)
	)

	thisTool.addRoll #(	DLGaboutRollout,
						DLGmainRollout,
						DLGobjectsRollout,
						DLGboundingBoxesRollout,
						DLGoptionsRollout) \
			rolledUp:#(	true,
						false,
						false,
						true,
						false)

	thisTool.openTool thisTool
)
)
