macroScript PropMan
category:"fooTOOLS"
buttontext:"PropMan"
tooltip:"PropMan - Change the properties of a selection"
icon:#("fooTOOLS-Icons",21)
(

------------------------------------------------------------------------------------------
-- Contents:
--		Property Manager - Set the values of misc object properties
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14) )
	)
) then (

	-- Change this path to point to where the script is installed!
	local propManPath = (getDir #ui) + "\\macroscripts"

	local thisTool = BFDtool	toolName:"PropMan"		\
								author:"John Burnett"	\
								createDate:[1999,06,15]	\
								modifyDate:[2001,05,21]		\
								version:1				\
								defFloaterSize:[250,250]

	if maxMasterDir != undefined then (
		if ((MaxVersion())[1] >= 4000) then
			propManPath = (maxMasterDir + "\\MacroScripts\\JBurnettOZ\\PropMan")
		else
			propManPath = (maxMasterDir + "\\ScriptsUser\\JBurnettOZ\\PropMan")
	)

	local propManButtonsCount = 17
	local propManButtons, propManButtonsMask
	local lockButtonsCount = 4
	local lockButtons, lockButtonsMask

	try (
		local b = OpenBitmap (propManPath + "\\fooTOOLS-PropMan_Buttons.bmp")
		propManButtons = GetCroppedBitmap b [0,0] [407,23]
		propManButtonsMask = GetCroppedBitmap b [0,24] [407,47]
		lockButtons = GetCroppedBitmap b [408,0] [471,15]
		lockButtonsMask = GetCroppedBitmap b [408,24] [471,39]
	) catch (
		propManButtons = bitmap (propManButtonsCount*24) 24 color:green
		propManButtonsMask = bitmap (propManButtonsCount*24) 24 color:black
		lockButtons = bitmap (lockButtonsCount*24) 24 color:green
		lockButtonsMask = bitmap (lockButtonsCount*24) 24 color:black
	)

	struct propManProp (name, prop, class)
	local DLGpropManRollout

	--Begin Class rollouts---------------------------------------------------------------------

	rollout DLGunknown "Unknown Type" (
		label DLGstr01 "-- Unknown Property Type Selected --" align:#center
		label DLGstr02 "" align:#center
		on DLGunknown open do (
			DLGstr02.text = "Type: " + (DLGpropManRollout.curProp.class as string)
		)
	)

	rollout DLGarray "Array" (
		label DLGlabel01 "Array Support Not Implemented"
		dropdownlist DLGop items:#("Add","Remove") across:2 enabled:false
		button DLGsetProp "Set Prop" enabled:false

		on DLGsetProp pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name DLGval.value DLGop.selected )
	)

	rollout DLGpoint3 "Point3" (
		spinner DLGx "X:" range:[-999999,999999,0] type:#float scale:0.1 fieldWidth:40 offset:[-141,0]
		checkbutton DLGlock images:#(lockButtons,lockButtonsMask,lockButtonsCount,1,3,2,4) toolTip:"Lock X, Y, and Z" width:16 height:16 offset:[-32,-21] checked:true enabled:true
		spinner DLGy "Y:" range:[-999999,999999,0] type:#float scale:0.1 fieldWidth:40 offset:[-60,-21] enabled:false
		spinner DLGz "Z:" range:[-999999,999999,0] type:#float scale:0.1 fieldWidth:40 offset:[5,-21] enabled:false
		dropdownlist DLGop items:#("Relative","Absolute","Multiply") across:2
		button DLGsetProp "Set Prop"

		on DLGx changed val do (
			if DLGlock.checked then DLGz.value = DLGy.value = DLGx.value
		)

		on DLGlock changed state do (
			DLGy.enabled = DLGz.enabled = not state
			if state then ( DLGy.value = DLGz.value = DLGx.value )
		)

		on DLGsetProp pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name (point3 DLGx.value DLGy.value DLGz.value) DLGop.selected )
	)

	rollout DLGfloat "Float" (
		spinner DLGval "Value:" range:[-999999,999999,0] type:#float scale:0.1 fieldWidth:40 align:#center
		dropdownlist DLGop items:#("Absolute","Relative","Multiply") across:2
		button DLGsetProp "Set Prop"

		on DLGsetProp pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name DLGval.value DLGop.selected )
	)

	rollout DLGinteger "Integer" (
		spinner DLGval "Value:" range:[-999999,999999,0] type:#float scale:1 fieldWidth:40 align:#center
		dropdownlist DLGop items:#("Absolute","Relative","Multiply") across:2
		button DLGsetProp "Set Prop"

		on DLGsetProp pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name DLGval.value DLGop.selected )
	)

	rollout DLGbooleanClass "Boolean" (
		button DLGtrue "Set True" width:60 across:3
		button DLGfalse "Set False" width:60
		button DLGtoggle "Toggle" width:60

		on DLGtrue pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name true #absolute )
		on DLGfalse pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name false #absolute )
		on DLGtoggle pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name undefined #toggle )
	)

	rollout DLGstring "String" (
		edittext DLGval "String:" fieldWidth:160 align:#center
		dropdownlist DLGop items:#("Replace","Prepend","Append") across:2
		button DLGsetProp "Set Prop"

		on DLGsetProp pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name DLGval.text DLGop.selected )
	)

	rollout DLGtime "Time" (
		spinner DLGval "Time Value (in frames):" range:[-999999,999999,0] type:#integer scale:1 fieldWidth:40 align:#center
		dropdownlist DLGop items:#("Absolute","Relative") across:2
		button DLGsetProp "Set Prop"

		on DLGsetProp pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name (DLGval.value as time) DLGop.selected )
	)

	rollout DLGcolor "Color" (
		colorPicker DLGval "Color:" color:black fieldWidth:40 height:16 title:"Color" align:#center
		dropdownlist DLGop items:#("Absolute","Add","Subtract","Multiply") across:2
		button DLGsetProp "Set Prop"

		on DLGsetProp pressed do ( DLGpropManRollout.SetPropSel DLGpropManRollout.curProp.name DLGval.color DLGop.selected )
	)

	local classRoll = #( \
		DLGunknown,
		DLGarray,
		DLGpoint3,
		DLGfloat,
		DLGinteger,
		DLGbooleanClass,
		DLGstring,
		DLGtime,
		DLGcolor )

	local classRollType = #( \
		#array,
		#point3,
		#float,
		#integer,
		#booleanClass,
		#string,
		#time,
		#color )

	--End Class rollouts---------------------------------------------------------------------

	rollout DLGpropManRollout "Property Manager" (
		local props = #()
		local curProp

		fn postRollout class = (
			for i in thisTool.numRolls() to 3 by -1 do thisTool.delRoll i

			if class != undefined then (
				local rollIdx = findItem classRollType ((class as string) as name)
				thisTool.addRoll classRoll[rollIdx+1]
			)
		)

		-- obj - object to change property in
		-- prop - property in object to change
		-- val - value to set property to
		-- op - how to set the property (add, multiply, append, etc)
		fn SetPropSel prop val op = (
			local sel = selection as array
			local propStr = prop as string
			local opName = op as name

			--format "prop: %, val: %, op: %, opName: %\n" prop val op opName

			case of (
				((opName==#relative) or (opName==#append)): (
					for obj in sel do (
						try ( setProperty obj propStr ((getProperty obj propStr)+val) ) catch ()
					)
				)
				(opName==#absolute): (
					for obj in sel do (
						try ( setProperty obj propStr val ) catch ()
					)
				)
				(opName==#replace): (
					for obj in sel do (
						try ( setProperty obj propStr (val as string) ) catch ()
					)
				)
				(opName==#add): (
					for obj in sel do (
						try ( setProperty obj propStr ((getProperty obj propStr)+val) ) catch ()
					)
				)
				(opName==#subtract): (
					for obj in sel do (
						try ( setProperty obj propStr ((getProperty obj propStr)-val) ) catch ()
					)
				)
				(opName==#multiply): (
					for obj in sel do (
						try ( setProperty obj propStr ((getProperty obj propStr)*val) ) catch ()
					)
				)
				(opName==#prepend): (
					for obj in sel do (
						try ( setProperty obj propStr (val+(getProperty obj propStr)) ) catch ()
					)
				)
				(opName==#toggle): (
					for obj in sel do (
						try ( setProperty obj propStr (not(getProperty obj propStr)) ) catch ()
					)
				)
			)
		)

		-- qsort: function to perform sort of array based on element property
		--	Larry Minton - Avguard Animations
		--	Rev. 1.0 6/11/98
		--	inputs:	array - array to be sorted
		--			compare - boolean function to compare 2 array elements and
		--				return TRUE if first element should appear before second
		--				element in sorted list
		--	outputs: array - sorted array
		fn PropQsort array compare = (
			local i, nvalues, gap, imax, exchanged, temp
			nvalues=array.count
			gap=nvalues
			while (gap >= 1) do (
				gap = gap/2
				imax=nvalues-gap
				do (
					exchanged=false
					for i=1 to imax do (
						iplusg=i+gap
						if (compare array[iplusg] array[i]) do (
							temp=array[i]
							array[i]=array[iplusg]
							array[iplusg]=temp
							exchanged=true
						)
					)
				) while exchanged
			)
		)

		fn compare_propName prop1 prop2 = (prop1.name < prop2.name)

		fn sortProps array = ( PropQsort array compare_propName )

		fn hasCurProp obj = (
			try (getProperty obj curProp.prop; true) catch (false)
		)

		fn defController obj prop = (
			try (execute ("animate on at time 1t $" + obj.name + "." + prop + " = $" + obj.name + "." + prop)
			execute ("deleteKey $" + obj.name + "." + prop + ".controller 1")) catch ()
			return (execute ("$" + obj.name + "." + prop + ".controller"))
		)

		fn getController obj prop = (
			local ctrl = execute ("$" + obj.name + "." + prop + ".controller")
			if ctrl == undefined then (
				ctrl = defController obj prop
			)
			return ctrl
		)

		fn assignController obj prop ctrl = (
			--local oldCtrl = getController obj prop
			--oldCtrl = ctrl
			local str = ("$" + obj.name + "." + prop + ".controller")
			ctrl = execute str
			if ctrl == undefined then (
				defController
			)
		)

		fn getProps props = (
			local foundProps = #()
			for obj in selection do (
				local tmpProps = getPropNames obj
				for prop in tmpProps do (
					if (findItem foundProps prop)==0 then (
						append props (propManProp name:(Capitalize (prop as string)) prop:prop class:(classOf (getProperty obj prop)))
						append foundProps prop
					)
				)
			)
		)

		fn updatePropList idx = (
			curProp = props[idx]
			DLGpropManRollout.DLGobjProps.selection = idx
			postRollout curProp.class
		)

		button DLGgetProps images:#(propManButtons,propManButtonsMask,propManButtonsCount,1,1,2,2) toolTip:"Get Properties" width:24 height:24 offset:[-92,0]
		dropdownlist DLGobjProps "" width:180 height:20 offset:[23,-27]
		button DLGprintProp images:#(propManButtons,propManButtonsMask,propManButtonsCount,8,8,9,9) toolTip:"Print Property to Listener" width:24 height:24 offset:[-20,0]
		button DLGprintAllProps images:#(propManButtons,propManButtonsMask,propManButtonsCount,10,10,11,11) toolTip:"Print All Properties to Listener" width:24 height:24 offset:[5,-29]
		checkbutton DLGmakeCopy images:#(propManButtons,propManButtonsMask,propManButtonsCount,12,14,13,14) toolTip:"Copy From Master" width:24 height:24 offset:[42,-29]
		checkbutton DLGcopyAll images:#(propManButtons,propManButtonsMask,propManButtonsCount,15,17,16,17) toolTip:"Copy All From Master" width:24 height:24 offset:[67,-29]
		checkbutton DLGmakeInstance images:#(propManButtons,propManButtonsMask,propManButtonsCount,3,5,4,5) toolTip:"Instance From Master" width:24 height:24 offset:[92,-29]

		on DLGgetProps pressed do (
			if selection.count >= 1 then (
				getProps (props=#())
				sortProps props

				if props.count >= 1 then (
					--Make dropdown list
					DLGobjProps.items = for prop in props collect prop.name
					updatePropList 1
				) else (
					DLGobjProps.items = #()
					postRollout undefined --remove any left over floaters
				)
			)
		)

		on DLGobjProps selected idx do (
			updatePropList idx
		)

		on DLGprintProp pressed do (
			if DLGpropManRollout.DLGobjProps.items.count >= 1 then (
				format "%\n\n" DLGpropManRollout.DLGobjProps.selected
			)
		)

		on DLGprintAllProps pressed do (
			if DLGpropManRollout.DLGobjProps.items.count >= 1 then (
				for i in DLGpropManRollout.DLGobjProps.items do (
					try (format "%\n" i) catch ()
				)
				format "\n"
			)
		)

		on DLGmakeCopy changed state do (
			DLGmakeCopy.enabled = false
			if state then (
				escapeEnable = false
				local master = pickObject count:1 filter:hasCurProp select:false
				escapeEnable = true
				DLGmakeCopy.checked = false; DLGmakeCopy.enabled = true
				if (master != undefined) and (master != #escape) then (
					local sel = selection as array
					local prop = curProp.name
					local val = (getProperty master curProp.prop)
					for obj in sel do (
						setProperty obj prop val
					)
				)
			)
			DLGmakeCopy.enabled = true
		)

		on DLGcopyAll changed state do (
			DLGcopyAll.enabled = false
			if state then (
				escapeEnable = false
				local master = pickObject count:1 select:false
				escapeEnable = true
				DLGcopyAll.checked = false; DLGcopyAll.enabled = true
				if (master != undefined) and (master != #escape) then (
					local sel = selection as array
					local props = getPropNames master
					for prop in props do (
						local val = (getProperty master prop)
						for obj in sel do (
							try (setProperty obj prop val) catch ()
						)
					)
				)
			)
			DLGcopyAll.enabled = true
		)

		on DLGmakeInstance changed state do (
			DLGmakeInstance.enabled = false
			if state then (
				escapeEnable = false
				local master = pickObject count:1 filter:hasCurProp select:false
				escapeEnable = true
				DLGmakeInstance.checked = false; DLGmakeInstance.enabled = true
				if (master != undefined) and (master != #escape) then (
					local sel = selection as array
					local prop = curProp.name
					if (defController master prop) == undefined then (
						messageBox "Cannot instance this property." title:"Error"
					) else (
						for obj in sel do (
							--try (
								execute ("$" + obj.name + "." + prop + ".controller = $" + master.name + "." + prop + ".controller")
							--) catch ()
						)
					)

					if false then (
						local masterControl = getController master prop
						for obj in sel do (
							try (
								assignController obj prop masterControl
							) catch ()
						)
					)
				)
			)
			DLGmakeInstance.enabled = true
		)
	)

	rollout DLGaboutpropManRollout "About" (
		button DLGpropManHelp "HELP"
		label DLGAbout01 "" offset:[0,5]
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGpropManHelp pressed do (
			local STRpropManHelp = "Property Manager Help -
  Property Manager lets you quickly set the value of many object properties in one pass.
For example, say you have 20 unique particle systems with different particle counts, and
you need to double the number of particles.  Instead of manually changing each system,
you could select them all and multiply their particle counts by 2.  Simple.

Usage:
  Select a group of objects (they don't have to be the same type).  Hit the
\"Get Properties\" button.  This will list all the available properties of all the objects
in the selection.
  When you select a property from the dropdown, a second rollout will appear that allows you
to change the value of the property.  This rollout is different depending on the property,
but in general you will have a way to change a value and a \"Set Prop\" button that will
apply your value.  There will also be a apply method dropdown that lets you apply your value
in different ways.  These include:

Absolute: Sets the property to the value you choose.
Relative: Adds the value you choose to the property.
Multiply: Multiplies the property by the value you choose.
Prepend/Append: Works with strings to add to a name.
Toggle: Works with checkboxes, and will change the value to the opposite of what it
  currently is.

You can then do any of the following:

-Print Property to Listener: Prints the selected property to the listener.  Handy if you're
  writing a script.
-Print All Properties to Listener: Prints all the listed properties to the listener.

Copy From Master: Copies a property value from a picked object.  ie. Select a group of spheres,
  pick \"Radius\" from the property list, hit \"Copy From Master\", and pick a sphere (it
  doesn't have to be selected).  All the selected sphere's radii will be set to the picked
  sphere's radius.
Instance From Master: Works like \"Copy From Master\", only works on animatable properties.
  In that case the property's controller will be instanced among all the selected objects, and
  updating one object will update them all.  Handy for making a \"selectively instanced\"
  object.

Tips and Caveats:
  You can change properties with the animate button on.  This will animate the change, like
any other value change in Max.

  You can sometimes set properties to greater values than they are usually allowed.  For
example, you can set a color to be greater than 255, which can cause that color to
\"blow out\", or do nothing, depending on the color swatch.  Just keep an eye out for these
situations, since it's easy to do using the \"multiply\" or \"relative\" apply modes.

  Some properties won't change properly in some situations.  An example of this is the text
shape object.  Changing the text will not have any effect UNLESS the modifier panel is open.
So if nothing seems to be happening, try making the change with the modifier panel active.

  Some properties aren't supported currently, and will throw up an undefined dialog.  If you
find one, write me."
			messageBox STRpropManHelp title:"Property Manager Help"
		)

		on DLGaboutpropManRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutpropManRollout close do ( thisTool.closeTool() )
	)

	thisTool.addRoll #(DLGaboutpropManRollout, DLGpropManRollout) rolledUp:#(true, false)

	thisTool.openTool thisTool
)
)
