macroScript Rename
category:"fooTOOLS"
buttontext:"Rename"
tooltip:"Rename - Rename Selected Objects"
icon:#("fooTOOLS-Icons",22)
(

------------------------------------------------------------------------------------------
-- Contents:
--		Rename - Rename selected objects
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14) )
	)
) then (

	local thisTool = BFDtool	toolName:"Rename"			\
								author:"John Burnett"		\
								createDate:[1997,12,01]		\
								modifyDate:[2001,08,21]		\
								version:1					\
								defFloaterSize:[256,190]

	rollout DLGaboutRenameRollout "About" (
		button DLGrenameHelp "HELP"
		label DLGAbout01 "" offset:[0,5]
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGrenameHelp pressed do (
			local STRrenameHelp = "This floater lets you rename a selection of objects in different ways.

Prefix:	Adds a prefix to the existing object name, won't change anything else.
Name:	Replaces the entire object name, EXCEPT for the object's end numbers (if any)
Postfix:	Adds a postfix to the existing object name, won't change anything else.

Renumber objects:
	If off, existing object numbering will be kept (if any)
	If on, existing object numbering will be replaced by numbers
	starting at the number specified in the spinner.

The default settings let you simply renumber objects while keeping their existing names.

The \"Search and Replace Selected\" rollout functions the same as any word processor.
It will search through the names of the selected objects for the specified search text,
and replace it with the replace text."
			messageBox STRrenameHelp title:"Rename Help"
		)

		on DLGaboutRenameRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRenameRollout close do ( thisTool.closeTool() )
	)

	rollout DLGrenameRollout "Rename Selected" (

		fn GetRenObjs = (
			local objs = #()
			for obj in selection do (
				if (isGroupMember obj) and not (isOpenGroupMember obj) then () else (
					--if not (isOpenGroupHead obj) then append objs obj
					append objs obj
				)
			)
			return objs
		)

		--objArray: array of objects to rename
		--prefixTxt: text to put in front of existing name
		--nameTxt: text to replace all but the end numbers with, if present
		--postfixTxt: text to tack on to the end, but still in front of end numbers, if present
		--renum: true if objects should be renumbered, false if old numbering is kept
		--startNum: if renumbering, the number that we start renumbering at
		fn renameSel objArray prefixTxt nameTxt postfixTxt renum startNum = (
			--local origNames = #(); for obj in objArray do append origNames obj.name
			local nums
			nums = #("1","2","3","4","5","6","7","8","9","0")
			--separate the end numbering from the main name
			local oldName = for obj in objArray collect ""	-- collect empty strings in case old
															-- numbers (in which case the numbers
															-- are all stripped off)
			local oldNum = #()
			local cnt = 0
			local progCnt = (objArray.count * 2) as float
			for obj in objArray do (
				cnt += 1
				for i = obj.name.count to 1 by -1 do (
					if (findItem nums obj.name[i]) == 0 then (
						oldName[cnt] = substring obj.name 1 i
						exit
					) else (
						if oldNum[cnt] != undefined then oldNum[cnt] = obj.name[i] + oldNum[cnt]
						else oldNum[cnt] = obj.name[i]
					)
				)
			)

			cnt = 0
			for obj in objArray do (
				cnt += 1
				if nameTxt != "" then obj.name = nameTxt else obj.name = oldName[cnt]
				obj.name = prefixTxt + obj.name + postfixTxt
				if renum then (
					if (cnt+startNum-1) < 10 then obj.name += ("0" + (cnt+startNum-1) as string)
					else ( obj.name += (cnt+startNum-1) as string )
				) else (
					if oldNum[cnt] != undefined then obj.name += oldNum[cnt]
				)
			)

			--See if any duplicate names were found, warn if necessary... can be big speed hit
			dupName = false
			if false then (
				for obj in objArray do (
					for allObj in objects do (
						if ((obj != allObj) and (obj.name == allObj.name)) then (
							dupName = true
							exit
						)
					)
				)
			)
			progressEnd()
			if dupName == true then messageBox "Warning: Duplicate object names found during renaming."
		)

		label DLGprefixNameLabel "Prefix:              Name:              Postfix:" offset:[0,-5]
		edittext DLGprefix "" fieldWidth:70 across:3 offset:[-13,-3]
		edittext DLGname "" fieldWidth:71 offset:[-6,-3]
		edittext DLGpostfix "" fieldWidth:70 offset:[2,-3]
		checkbox DLGrenum "Renumber objects, starting at" checked:false offset:[-9,0]
		spinner DLGstartNum "" type:#integer range:[0,999999,1] width:60 offset:[30,-20] enabled:false
		button DLGrenameIt "Rename Selected" width:160 offset:[0,2]

		on DLGrenum changed state do (
			if state == true then DLGstartNum.enabled = true else DLGstartNum.enabled = false
		)

		on DLGrenameIt pressed do (
			PushCommandPanelTaskMode #create
			local objs = GetRenObjs()
			renameSel	objs \
						DLGrenameRollout.DLGprefix.text \
						DLGrenameRollout.DLGname.text \
						DLGrenameRollout.DLGpostfix.text \
						DLGrenum.checked \
						DLGstartNum.value
			PopCommandPanelTaskMode()
		)

		on DLGrenameRollout close do (
			try (DLGrenameFloaterButton.checked = false) catch ()
		)
	)

	rollout DLGsearchReplaceRollout "Search And Replace Selected" (
		label DLGsearchLabel "Search For:" align:#left
		edittext DLGsearchText "" offset:[-4,0]
		label DLGreplaceLabel "Replace With:" align:#left
		edittext DLGreplaceText "" offset:[-4,0]
		checkbox DLGcaseSensitive "Case Sensitive" across:2
		checkbox DLGpointCache "PointCache Files"
		button DLGsearchReplace "Search And Replace"

		on DLGsearchReplace pressed do (
			if DLGsearchText.text == "" then return()

			PushCommandPanelTaskMode #create
			if (DLGpointCache.checked) then (
				local mods = #()
				for obj in selection do (
					for m in obj.modifiers where (
						(ClassOf m == Point_Cache_2) OR
						(ClassOf m == Point_Cache_2SpacewarpModifier)
					) do Append mods m
				)

				for m in mods do (
					m.cacheFile = (
						SearchReplace	m.cacheFile			\
										DLGsearchText.text	\
										DLGreplaceText.text	\
										caseSensitive:DLGcaseSensitive.checked
					)
				)
			) else (
				local objs = DLGrenameRollout.GetRenObjs()
				for obj in objs do (
					obj.name = (searchReplace obj.name DLGsearchText.text DLGreplaceText.text caseSensitive:DLGcaseSensitive.checked)
				)
			)
			PopCommandPanelTaskMode()
		)
	)

	thisTool.addRoll #(DLGaboutRenameRollout, DLGrenameRollout, DLGsearchReplaceRollout) rolledUp:#(true,false,true)

	thisTool.openTool thisTool
)
)
