macroScript Replacer
category:"fooTOOLS"
buttontext:"Replacer"
tooltip:"Replacer - Replace Selected Objects"
icon:#("fooTOOLS-Icons",23)
(

------------------------------------------------------------------------------------------
-- Contents:
--		Replacer - Replace selected object(s) with other object(s)
--
-- Requires:
--		jbFunctions.ms
--		avg_dlx.dlx
------------------------------------------------------------------------------------------

--TODO:
--offset for single anim
--disable viewports
--progress bar

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("avg_dlx",2.09) )
	)
) then (

	local thisTool = BFDtool	toolName:"Replacer"			\
								author:"John Burnett"		\
								createDate:[1999,01,01]		\
								modifyDate:[2001,05,21]		\
								version:2					\
								defFloaterSize:[250,595]

	seed 1

	-- Transform the animation of objects in objs array
	fn transformAnimation objs tOffset tScale = (
		for obj in objs do (
			for i in 1 to obj[3].numsubs do (
				local ctrls = #()
				append ctrls obj[3][i]
--				if obj.baseObject == Morph then append ctrls obj.baseObject.morph

				for ctrl in ctrls do (
					if ctrl.keys.count >= 2 then (
						local tRange = interval ctrl.keys[1].time ctrl.keys[ctrl.keys.count].time
						try (scaleTime ctrl tRange tScale) catch ()
					)
					for k in ctrl.keys do try ( k.time += tOffset ) catch ()
				)
			)
		)
	)

	rollout DLGaboutrepRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutrepRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutrepRollout close do ( thisTool.closeTool() )
	)

	struct replacerSet (
		setName = "",
		useSet = true,
		srcObjs = #(),
		srcWeights = #(),
		srcColors = #(),
		fn numObjs = (
			return srcObjs.count
		),
		fn delObj idx = (
			deleteItem srcObjs idx
			deleteItem srcWeights idx
			deleteItem srcColors idx
		),
		fn addObj obj = (
			if (findItem srcObjs obj) == 0 then (
				append srcObjs obj
				append srcWeights 1.0
				append srcColors (getHue (random 0.0 1.0))
			)
		),
		fn swapObjs a b = (
			swap srcObjs[a] srcObjs[b]
			swap srcWeights[a] srcWeights[b]
			swap srcColors[a] srcColors[b]
		),
		fn cleanObjs = (
			for i in srcObjs.count to 1 by -1 do (
				if try ( (srcObjs[i] == undefined) OR (isDeleted srcObjs[i]) ) catch (true) then (
					try ( delObj i ) catch ()
				)
			)
		)
	)

	rollout DLGrepRollout "Replacer" (
		local useSelSets
		local repType			-- Type of replace (#instance or #replace)
		local sets				-- Array of replacerSets
		local curSet			-- Current array being edited in arrays above
		local curObj			-- Current object index selected in object listbox
		local seedVal
		local includeChildren
		local useInstanceAnim
		local numUnique
		local maxOffset
		local maxScale
		local colorCode
		local useRandomColors
		local statusStr			-- String to display in the status label at the bottom

		fn isObject obj = ( true )

		fn updateUI = (
-- TODO: make sure selection sets are still valid

			-- Trim array of any deleted objects
			for i in 1 to sets.count do sets[i].cleanObjs()

			-- Create list of object names for listbox
			local tmp = for i in 1 to sets[curSet].srcObjs.count collect ((i as string) + ": " + sets[curSet].srcObjs[i].name)
			DLGrepRollout.DLGobjList.items = tmp
			if (curObj == 0) AND (tmp.count != 0) then curObj = 1
			if (curObj >= tmp.count) then curObj = tmp.count
			DLGrepRollout.DLGobjList.selection = curObj

			tmp = if useSelSets then (
				for i in 1 to selectionSets.count collect (
					local tmpStr = if sets[i].useSet then "* " else "  "
					tmpStr + (getNamedSelSetName i)
				)
			) else #()
			DLGrepRollout.DLGselSets.items = tmp
			if useSelSets then (
				if (curSet == 0) AND (tmp.count != 0) then curSet = 1
				if (curSet >= tmp.count) then curSet = tmp.count
			)
			DLGrepRollout.DLGselSets.selection = curSet

			DLGrepRollout.DLGuseSelSets.state = if useSelSets then 2 else 1
			DLGrepRollout.DLGuseSet.checked = sets[curSet].useSet
			DLGrepRollout.DLGdoReplace.text = if useSelSets then "Replace Active Sets" else "Replace Selected"

			-- Set UI values
			local idx = 1
			for i in 1 to DLGrepRollout.DLGreplaceType.items.count do (
				if (DLGrepRollout.DLGreplaceType.items[i] as name) == repType then idx = i
			)
			DLGrepRollout.DLGreplaceType.selection = idx

			DLGrepRollout.DLGseedVal.value = seedVal
			DLGrepRollout.DLGincludeChildren.checked = includeChildren
			DLGrepROllout.DLGuseInstanceAnim.checked = useInstanceAnim
			DLGrepRollout.DLGnumUnique.value = numUnique
			DLGrepRollout.DLGmaxOffset.value = maxOffset
			DLGrepRollout.DLGmaxScale.value = maxScale * 100.
			DLGrepRollout.DLGcolorCode.checked = colorCode
			DLGrepRollout.DLGuseRandomColors.checked = useRandomColors
			if sets[curSet].numObjs() != 0 then (
				DLGrepRollout.DLGrelativeWeight.value = sets[curSet].srcWeights[curObj]
			)
			DLGrepRollout.DLGsrcColor.color = if includeChildren AND NOT useRandomColors AND (sets[curSet].numObjs() != 0) then (
				sets[curSet].srcColors[curObj]
			) else (
				color 192 192 192
			)
			DLGrepRollout.DLGstatusStr.text = statusStr

			-- Set UI enable states
			DLGrepRollout.DLGselSets.enabled =
				DLGrepRollout.DLGrefreshSelSets.enabled =
				DLGrepRollout.DLGuseSet.enabled =
				DLGrepRollout.DLGallSets.enabled =
				DLGrepRollout.DLGnoneSets.enabled =
				DLGrepRollout.DLGinvertSets.enabled = useSelSets
			DLGrepRollout.DLGnumUnique.enabled =
				DLGrepRollout.DLGuseInstanceAnimLabel.enabled =
				DLGrepRollout.DLGuseInstanceAnim.enabled =
				DLGrepRollout.DLGcolorCodeLabel.enabled =
				DLGrepRollout.DLGcolorCode.enabled = includeChildren
			DLGrepRollout.DLGuseRandomColors.enabled =
				DLGrepRollout.DLGuseRandomColorsLabel.enabled = includeChildren AND colorCode
			DLGrepRollout.DLGmaxOffset.enabled =
				DLGrepRollout.DLGmaxScale.enabled = includeChildren AND (numUnique > 1)
			DLGrepRollout.DLGsrcColor.enabled = includeChildren AND NOT useRandomColors AND (sets[curSet].numObjs() != 0)

			DLGrepRollout.DLGclearObj.enabled =
				DLGrepRollout.DLGclearAllObj.enabled =
				DLGrepRollout.DLGmoveUp.enabled =
				DLGrepRollout.DLGmoveDown.enabled =
				DLGrepRollout.DLGobjList.enabled =
				DLGrepRollout.DLGdoReplace.enabled =
				DLGrepRollout.DLGrelativeWeight.enabled = (sets[curSet].numObjs() != 0)
		)

		group "Target Objects:" (
			radiobuttons DLGuseSelSets "" labels:#("Use Current Selection","Use Selection Sets") columns:1 align:#left
			button DLGrefreshSelSets "refresh" width:40 height:15 offset:[79,-22]
			dropdownlist DLGselSets "" width:198
			checkbox DLGuseSet "Include" offset:[0,0]
			button DLGallSets "All" width:35 height:15 offset:[10,-20]
			button DLGnoneSets "None" width:35 height:15 offset:[46,-20]
			button DLGinvertSets "Invert" width:35 height:15 offset:[80,-20]
		)

		group "Source Objects:" (
			pickbutton DLGaddPickObj "Add Pick" tooltip:"Add Picked Object To List" filter:isObject width:50 height:16 align:#left offset:[0,-1]
			button DLGaddSelObj "Add Sel" tooltip:"Add Selected Objects To List" width:50 height:16 align:#left offset:[0,-4]
			button DLGclearObj "Clear" tooltip:"Clear Selected List Item" width:50 height:16 align:#left offset:[0,-4]
			button DLGclearAllObj "Clear All" tooltip:"Clear Entire List" width:50 height:16 align:#left offset:[0,-4]
			button DLGmoveUp "/\\" tooltip:"Move Item Up" width:16 height:24 offset:[-35,-72]
			button DLGsortList "" width:16 height:19 offset:[-35,-5] enabled:false
			button DLGmoveDown "\\/" tooltip:"Move Item Down" width:16 height:24 offset:[-35,-5]
			listbox DLGobjList height:5 width:128 offset:[71,-75]
			spinner DLGrelativeWeight "Relative Weight: " range:[0,9999,1.0] type:#float width:75 align:#right
			colorpicker DLGsrcColor "Base Color:" fieldWidth:41 height:20 align:#right
		)

		group "Replace Options:" (
			label DLGreplaceTypeLabel "Replace Type: " offset:[-60,0]
			dropdownlist DLGreplaceType "" items:#("Instance","Reference") width:120 offset:[75,-21]
			label DLGseedValLabel "Random Seed Value:" align:#left offset:[2,0]
			spinner DLGseedVal "" range:[0,999999,0] type:#integer width:60 offset:[-1,-18]
			button DLGrandomSeed "R" width:15 height:17 offset:[87,-22]
			checkbox DLGincludeChildren "Include Children" align:#left offset:[2,0]
			spinner DLGnumUnique "Num. Unique Animations:" range:[1,999,1] type:#integer width:93 offset:[121,0]
			spinner DLGmaxOffset "Max. Frame Offset:" range:[0,998,0] type:#integer width:80 offset:[50,0]
			spinner DLGmaxScale "+/- Time Scale %:" range:[0,100,0] type:#float scale:1.0 width:78 offset:[48,0]
			label DLGuseInstanceAnimLabel "Use Instance Animation" align:#right offset:[-25,0]
			checkbox DLGuseInstanceAnim "" align:#right offset:[6,-18]
			label DLGcolorCodeLabel "Color Code" align:#right offset:[-25,0]
			checkbox DLGcolorCode "" align:#right offset:[6,-18]
			label DLGuseRandomColorsLabel "Use Random Colors" align:#right offset:[-25,0]
			checkbox DLGuseRandomColors "" align:#right offset:[6,-18]
		)

		button DLGdoReplace "" align:#center
		label DLGstatusStr "" align:#center

		on DLGuseSelSets changed idx do (
			local state = (idx == 2)
			if state != useSelSets then (
				curSet = 1
				if (state AND (selectionSets.count == 0)) then (
					-- tried to switch to sel sets, but none present
					-- so do nothing
				) else if NOT state then (
					-- switched to use selection
					useSelSets = false
					sets = #(replacerSet())
				) else (
					-- switched to use sel sets
					useSelSets = true
					for i in 1 to selectionSets.count do (
						sets[i] = replacerSet setName:(getNamedSelSetName i)
					)
				)
			)
			updateUI()
		)
		on DLGselSets selected idx do ( curSet = idx; updateUI() )
		on DLGrefreshSelSets pressed do ( updateUI() )
		on DLGuseSet changed state do ( sets[curSet].useSet = state; updateUI() )
		on DLGallSets pressed do ( for s in sets do s.useSet = true; updateUI() )
		on DLGnoneSets pressed do ( for s in sets do s.useSet = false; updateUI() )
		on DLGinvertSets pressed do ( for s in sets do s.useSet = NOT s.useSet; updateUI() )
		on DLGreplaceType selected i do ( repType = (DLGreplaceType.selected as name); updateUI() )
		on DLGseedVal changed val do ( seedVal = val; updateUI() )
		on DLGrandomSeed pressed do ( seedVal = (random 0. 999999) as integer; updateUI() )
		on DLGincludeChildren changed state do ( includeChildren = state; updateUI() )
		on DLGuseInstanceAnim changed state do ( useInstanceAnim = state; updateUI() )
		on DLGnumUnique changed val do (
			numUnique = val
			if maxOffset < (numUnique-1) then maxOffset = (numUnique-1)
			updateUI()
		)
		on DLGmaxOffset changed val do (
			maxOffset = val
			if numUnique > (maxOffset+1) then numUnique = (maxOffset+1)
			updateUI()
		)
		on DLGmaxScale changed val do ( maxScale = val / 100.; updateUI() )
		on DLGcolorCode changed state do ( colorCode = state; updateUI() )
		on DLGuseRandomColors changed state do ( useRandomColors = state; updateUI() )

		on DLGaddPickObj picked obj do (
			sets[curSet].addObj obj
			updateUI()
		)
		on DLGaddSelObj pressed do (
			for obj in (selection as array) do sets[curSet].addObj obj
			updateUI()
		)
		on DLGclearObj pressed do (
			sets[curSet].delObj curObj
			updateUI()
		)
		on DLGclearAllObj pressed do (
			sets[curSet] = replacerSet setName:(getNamedSelSetName curSet)
			updateUI()
		)
		on DLGmoveUp pressed do (
			if (sets[curSet].numObjs() > 1) AND (curObj > 1) AND (curObj <= sets[curSet].numObjs()) then (
				sets[curSet].swapObjs curObj (curObj-1)
				curObj -= 1
			)
			updateUI()
		)
		on DLGmoveDown pressed do (
			if (sets[curSet].numObjs() > 1) AND (curObj > 0) AND (curObj < sets[curSet].numObjs()) then (
				sets[curSet].swapObjs curObj (curObj+1)
				curObj += 1
			)
			updateUI()
		)
		on DLGobjList selected idx do ( curObj = idx; updateUI() )
		on DLGrelativeWeight changed val do (
			sets[curSet].srcWeights[curObj] = val
			updateUI()
		)
		on DLGsrcColor changed col do (
			sets[curSet].srcColors[curObj] = col
			updateUI()
		)

		on DLGdoReplace pressed do (
			local aTimer = lapTimer()
			local oldSel = selection as array
			clearSelection()

			local cmdMode = getCommandPanelTaskMode()
			if cmdMode != #create then setCommandPanelTaskMode mode:#create
			disableSceneRedraw()

			progressStart "Replacing..."

			seed seedVal

			-- How many object are we replacing in total (for progress bar only)
			local totObjCount = 0
			local cnt = 1
			if useSelSets then (
				for i in 1 to sets.count do (
					if sets[i].useSet then totObjCount += selectionSets[i].count
				)
			) else (
				totObjCount = oldSel.count
			)

			-- Keep objects we've replaced, so we don't replace twice
			-- in case some objects are in more than one selection set
			local allTargObjs = #()

			for setIdx in 1 to sets.count do (
				aTimer.cleanStart()
				local targObjs = if useSelSets then selectionSets[setIdx] else oldSel

				if	(sets[setIdx].numObjs() >= 1) AND
					(targObjs.count >= 1) AND
					(sets[setIdx].useSet) then (

					local srcObjs = sets[setIdx].srcObjs
					local srcWeights = sets[setIdx].srcWeights
					local srcColors = sets[setIdx].srcColors
					-- Set up arrays for offset animation:
					-- All this is necessary to create the bare minimum of uninstanced
					-- animations, in order to save space...
					-- srcTrees.count == srcObjs.count
					-- each srcTrees[i] is a sub-array, where srcTrees[i][j].count == numUnique
					-- each srcTrees[i][j] holds all the instanced objects of a hierarchy,
					--   with its animation offset by the value held in the randomOffsets[j] array
					-- whichTree.count == srcObjs.count, and is an array of counters,
					--   pointing to which srcTrees[i][j] was last used
					-- randomColors.count == srcObjs.count, and is an array of arrays
					--   randomColors[n].count == numUnique
					--   randomColors[n] is a dark -> light color gradient of a single hue
					-- ie: srcTrees[5][3] == copy of srcObjs[5], offset by randomOffsets[3]
					local srcTrees = #()
					local randomTransforms = #()
					local whichTree = #()
					local randomColors = #()
					if includeChildren then (
						-- Pre-allocate all the arrays in the srcTrees array
						srcTrees[srcObjs.count] = undefined
						local tmp = #(); tmp[numUnique] = undefined
						for i in 1 to srcTrees.count do srcTrees[i] = copy tmp #nomap

						-- Create an array from 1 to (frameOffset+1), and scramble
						-- the ordering, then trim it down to a size == numUnique
						if maxOffset > 0 then (
							-- Create array of all possible offsets
							randomTransforms[maxOffset] = undefined
							for i in 1 to maxOffset do randomTransforms[i] = #(i,undefined)
							-- Scramble it
							scrambleArray randomTransforms
							-- Trim it down to minimum number of offsets
							if maxOffset > numUnique then (
								for i in randomTransforms.count to numUnique by -1 do deleteItem randomTransforms i
							)
							-- Make random scalings
							for i in 1 to randomTransforms.count do (
								randomTransforms[i][2] = random (1. - maxScale) (1. + maxScale)
							)
						)
						-- First transform is always neutral
						randomTransforms = #(#(0,1.)) + randomTransforms

						-- Set all counters to 1
						whichTree[srcObjs.count] = undefined
						for i in 1 to srcObjs.count do whichTree[i] = 1

						-- Create random colors
						if colorCode then (
							-- Each source object gets a unique hue
							local baseColors = #(); baseColors[srcObjs.count] = undefined
							if useRandomColors then (
								for i in 1 to srcObjs.count do (
									baseColors[i] = getHue ((i-1.)/srcObjs.count)
								)
							) else (
								for i in 1 to srcColors.count do baseColors[i] = copy srcColors[i]
							)

							-- Each variant of a source object gets its own value
							randomColors = for i in 1 to srcObjs.count collect #()
							for i in 1 to randomColors.count do (
								local c = baseColors[i]
								local minCol = c * 0.25
								local maxCol = ((white - c) * 0.75) + c
								for j in 1 to numUnique do (
									local n = (j as float)/numUnique
									if n < 0.5 then (
										n *= 2
										c = (c * n) + (minCol * (1-n))
									) else (
										n = (n - 0.5) * 2
										c = (c * n) + (maxCol * (1-n))
									)
									randomColors[i][j] = clampCol c
								)
								for j in 1 to numUnique do (
									local c = baseColors[i]
									c *= (j as float)/numUnique
									randomColors[i][j] = clampCol c
								)
							)
						)
					)

---- Normalize the source object weight array,
---- and create a final set of arrays that are sorted
---- according to weight
--local normWeights = for w in srcWeights collect w
--local normObjs = for obj in srcObjs collect obj
--local totWeight = 0.0
--for w in normWeights do totWeight += w
--for i in 1 to normWeights.count do (
--	normWeights[i] /= totWeight
--)
					local normObjs = for obj in srcObjs collect obj
					local normWeights = for w in srcWeights collect w
					for i in normWeights.count to 1 by -1 do (
						local tot = 0
						for j in 1 to (i-1) do tot += normWeights[j]
						normWeights[i] += tot
					)

					-- Merge all arrays to do with the source objects,
					-- sort it according to weight, and break it apart again
					-- (to keep all the arrays associated with the object array in sync)
					local packedObjs = #(); packedObjs[normObjs.count] = undefined
					for i in 1 to normObjs.count do (
						packedObjs[i] = #(normWeights[i],
										normObjs[i],
										srcTrees[i],
										randomColors[i],
										randomTransforms[i])
					)
					qSort packedObjs (fn sortWeights wA wB = (if wA[1] < wB[1] then -1 else if wA[1] > wB[1] then 1 else 0))
					for i in 1 to packedObjs.count do (
						normWeights[i] = packedObjs[i][1]
						normObjs[i] = packedObjs[i][2]
						srcTrees[i] = packedObjs[i][3]
						randomColors[i] = packedObjs[i][4]
						randomTransforms[i] = packedObjs[i][5]
					)

					-- Loop through all targObjs and do the actual replacing
					for i in 1 to targObjs.count do (
						local targObj = targObjs[i]
						if (findItem allTargObjs targObj) == 0 then (
							append allTargObjs targObj
						) else (
							-- skip... already replaced object
							continue
						)
--(t=0;s=0;c=0;for i in $ do if co i == sphere then s+=1 else if co i == cube then c+=1 else t +=1);t;s;c
---- Find which object to use according to weights
--local w = random 0. 1.
---- find first normWeight that is >= w
--local srcIdx
--local minIdx = normWeights.count
--while (minIdx >= 2) AND (normWeights[minIdx] > w) do minIdx -= 1
---- See if any other normWeights have the same value
--local maxIdx = minIdx
--while (maxIdx < normWeights.count) AND (normWeights[maxIdx+1] == normWeights[minIdx]) do maxIdx += 1
---- If more than one weight is the same, pick one at random
--if maxIdx > minIdx then (
--	-- Workaround: random never seems to spit out the max value
--	srcIdx = (random (minIdx as float) (maxIdx+1)) as integer
--	if srcIdx > normObjs.count then srcIdx = normObjs.count
--) else (
--	srcIdx = minIdx
--)
--local srcObj = normObjs[srcIdx]
						local r = random 0. normWeights[normWeights.count]
						local srcIdx = 1
						while r > normWeights[srcIdx] do srcIdx += 1
						local srcObj = normObjs[srcIdx]

						case repType of (
							#instance: instanceReplace targObj srcObj
							#reference: referenceReplace targObj srcObj
						)

						-- Duplicate srcObj's children if necessary
						if includeChildren then (
							-- Which hierarchy dup function to use
							local dupTree = case repType of (
								#instance: instanceHierarchy
								#reference: referenceHierarchy
							)

							-- Which copy of srcObjs[i] to use
							local treeIdx = whichTree[srcIdx]
							whichTree[srcIdx] += 1
							if whichTree[srcIdx] > numUnique then whichTree[srcIdx] = 1

							local curTree
							if (srcTrees[srcIdx][treeIdx] != undefined) AND useInstanceAnim then (
								-- use existing instance
								curTree = dupTree srcTrees[srcIdx][treeIdx][1] instanceAnimation:true
							) else (
								-- make a new copy, offset animation, and store it for future use
								curTree = dupTree normObjs[srcIdx]
								transformAnimation curTree randomTransforms[treeIdx][1] randomTransforms[treeIdx][2]
								srcTrees[srcIdx][treeIdx] = curTree
							)

							-- Set top parent to replaced object's transform
							curTree[1].transform = targObj.transform

							-- Remap all necessary children to use replaced object as parent
							for child in curTree do (
								if child.parent == curTree[1] then child.parent = targObj
							)
							-- Delete top parent, use new parent in next instance
							delete curTree[1]
							curTree[1] = targObj

							-- Assign color coded colors
							if colorCode then (
								for obj in curTree do obj.wireColor = randomColors[srcIdx][treeIdx]
							)
						)

						progressUpdate (((cnt+=1)/totObjCount as float)*100)
					) -- End (i in 1 to targObjs.count) loop
				)
				statusStr = "Last Replace Time: " + (getFormattedTime (aTimer.stop()))
			) -- End (setIdx in 1 to sets.count) loop
			gc()
			progressEnd()
			enableSceneRedraw()
			select oldSel
			if cmdMode != #create then setCommandPanelTaskMode mode:cmdMode
			updateUI()
		)

		on DLGrepRollout open do (
			useSelSets = false
			repType = #instance
			sets = #(replacerSet())
			curSet = 1
			curObj = 0
			seedVal = 123456
			includeChildren = false
			useInstanceAnim = true
			numUnique = 1
			maxOffset = 0
			maxScale = 0.0
			colorCode = true
			useRandomColors = true
			statusStr = "Last Replace Time: " + (getFormattedTime 0.0)
			updateUI()
		)
	)

	thisTool.addRoll #(DLGaboutrepRollout, DLGrepRollout) rolledUp:#(true,false)
	thisTool.openTool thisTool
)
)
