macroScript SelectionMan
category:"fooTOOLS"
buttontext:"SelectionMan"
tooltip:"SelectionMan - Selection Manager"
icon:#("fooTOOLS-Icons",24)
(

------------------------------------------------------------------------------------------
-- Contents:
--		SelectionMan - Description: Various selection tools
--
-- Requires:
--		jbFunctions.ms
--		Avg_dlx.dlx
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("avg_dlx",2.09) )
	)
) then (

	local thisTool = BFDtool	toolName:"SelectionMan"					\
								author:"John Burnett, Jared Keller"		\
								createDate:[1999,01,27]					\
								modifyDate:[2001,05,21]					\
								version:5								\
								defFloaterSize:[200,196]

	local OSS = 1
	local VSS = 2
	local FSS = 3
	local ESS = 4

	rollout DLGaboutRollout "About" (
		label DLGAbout01 ""
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do (
			thisTool.closeTool()
		)
	)

	rollout DLGmainRollout "Selection Tools" (
		local eCache	--vertex/face cache, re-built only when necessary
						--eCache[1] == object in cache
						--eCache[2] == num expected verts
						--eCache[3] == num expected faces
						--eCache[4] == the vert/face cache
						--eCache[5] == elements cache
		local pCache	--polygon cache, re-built only when necessary
						--pCache[1] == object in cache
						--pCache[2] == num expected verts
						--pCache[3] == num expected faces
						--pCache[4] == the polygons of the object


		fn trimArray ary perc = (
			local newSize, oldAry, newAry, rnd
			oldAry = copy ary #nomap
			newAry = #()
			newSize = (oldAry.count*(perc/100.0)+0.5) as integer
			for i = 1 to newSize do (
				rnd = random 1 oldAry.count
				append newAry oldAry[rnd]
				deleteItem oldAry rnd
			)
			return newAry
		)

		-- Stupid, lazy workaround for 3.x
		fn bitArrayToInts ary = (
			local ints = #()
			for i in 1 to ary.count do (
				if ary[i] then append ints i
			)
			return ints
		)

		fn intsToBitArray ints = (
			local ba = #{}
			for i in ints do (
				ba[i] = true
			)
			return ba
		)

		fn trimBitArray ary perc = (
			local newAry = bitArrayToInts ary
			newAry = trimArray newAry perc
			newAry = intsToBitArray newAry
			return newAry
		)
		-- End stupid, lazy workaround for 3.x

		fn validECache obj = (
			return (
				(eCache[1] == obj) AND
				(eCache[2] == obj.numVerts) AND
				(eCache[3] == obj.numFaces)
			)
		)

		fn buildECache obj = (
			eCache[1] = obj
			eCache[2] = obj.numVerts
			eCache[3] = obj.numFaces
			eCache[4] = getVertFaceCache obj
			eCache[5] = getAllMeshElements obj eCache[4]
		)

		fn getVFCache = (
			eCache[4]
		)

		fn getElementCache = (
			eCache[5]
		)

		fn validPCache obj = (
			return (
				(pCache[1] == obj) AND
				(pCache[2] == obj.numVerts) AND
				(pCache[3] == obj.numFaces)
			)
		)

		fn buildPCache obj = (
			pCache[1] = obj
			pCache[2] = obj.numVerts
			pCache[3] = obj.numFaces
			gc()
			pCache[4] = getAllPolygonsProgress obj
		)

		fn getPolyCache = (
			pCache[4]
		)

--		fn bitAND a b = (
--			local cnt = if a.count < b.count then a.count else b.count
--			local c = #{1..cnt}
--			for i in 1 to cnt do c[i] = a[i] AND b[i]
--			return c
--		)
		fn bitAND a b = (
			local atemp = a
			local btemp = b
			atemp[btemp.count] = atemp[btemp.count]
			btemp[atemp.count] = btemp[atemp.count]
			-(-atemp+-btemp)
		)

		edittext DLGselByName "" width:90 offset:[-10,0]
		checkbox DLGkeepSel "Keep Sel" offset:[87,-21]
		button DLGselRand "Select Random" offset:[-35,0]
		button DLGresetCache "R" tooltip:"Rebuild Elements Cache" width:15 offset:[18,-26]
		spinner DLGrandSelPerc "%" range:[0,100,50] type:#float scale:0.1 fieldWidth:32 offset:[5,-23]

		on DLGselByName entered str do (
			if str == "" then return()
			if DLGkeepSel.checked then (
				try (execute ("selectMore $" + str)) catch ()
			) else (
				try (execute ("select $" + str)) catch ()
			)
			DLGselByName.text = ""
		)

		on DLGresetCache pressed do (
			if	(selection.count == 1) AND
				(classOf selection[1] == Editable_mesh) AND
				(selection[1].modifiers.count == 0) then (
				case subObjectLevel of (
					4: (buildPCache selection[1])
					5: (buildECache selection[1])
					default: (
						messageBox "Must be in Polygon or Element Sub-Object mode." title:"Error"
					)
				)
			) else (
				messageBox "Must have one collapsed editable mesh selected" title:"Error"
			)
		)

		on DLGselRand pressed do (
			local selSet = #{}
			local perc = DLGrandSelPerc.value
			if (selection.count == 1) and
			   (classOf selection[1] == Editable_mesh) and
			   (selection[1].modifiers.count == 0) and
			   (subObjectLevel != undefined) and
			   (subObjectLevel != 0) then (
				local obj = selection[1]
				case subObjectLevel of (
					1: (
						local ar = if (obj.selectedVerts.count==0) then #{1..obj.numVerts} else (getVertSelection obj)
						selSet = trimBitArray ar perc
						setVertSelection obj selSet
					)
					2: (
						local ar = if (obj.selectedEdges.count==0) then #{1..(obj.numFaces*3)} else (getEdgeSelection obj)
						selSet = trimBitArray ar perc
						setEdgeSelection obj selSet
					)
					3: (
						local ar = if (obj.selectedFaces.count==0) then #{1..obj.numFaces} else (getFaceSelection obj)
						selSet = trimBitArray ar perc
						setFaceSelection obj selSet
					)
					4: (
						if NOT (validPCache obj) do buildPCache obj
						local sets = trimArray (getPolyCache()) perc
						for s in sets do selSet += s
						if (obj.selectedFaces.count!=0) do selSet = bitAND selSet (getFaceSelection obj)
						setFaceSelection obj selSet
					)
					5: (
						if NOT (validECache obj) do buildECache obj
						local sets = trimArray (getElementCache()) perc
						for s in sets do selSet += s
						if (obj.selectedFaces.count!=0) do selSet = bitAND selSet (getFaceSelection obj)
						try (setFaceSelection obj selSet) catch ()
					)
				)
				update obj
			) else (
				max create mode
				local ar = if (selection.count==0) then (
					for obj in objects where (NOT obj.isHidden) AND (NOT obj.isFrozen) collect obj
				) else (
					selection as array
				)
				selSet = trimArray ar DLGrandSelPerc.value
				select selSet
			)
		)

		on DLGmainRollout open do (
			eCache = #(undefined,0,0,#(),#())
			pCache = #(undefined,0,0,#())
		)
	)

	rollout DLGselectByObjProp "Select By Object Property" (
		fn DoSelect objs = (
			if DLGselectByObjProp.DLGignoreHidden.checked then (
				local selObjs = for obj in objs where NOT obj.isHidden AND NOT obj.isFrozen collect obj
				if DLGselectByObjProp.DLGkeepSel.checked then (
					SelectMore selObjs
				) else (
					Select selObjs
				)
			) else (
				SelectAndShow objs keepSel:DLGselectByObjProp.DLGkeepSel.checked
			)
		)

		checkbox DLGkeepSel "Keep Sel." align:#left offset:[-7,0]
		checkbox DLGignoreHidden "Ignore Hidden" checked:true align:#right offset:[9,-20]
		group "Select Objects With:" (
			label DLGrenderableLabel "Renderable:" align:#left
				button DLGselRendOn "On" width:30 height:16 offset:[30,-19]
				button DLGselRendOff "Off" width:30 height:16 offset:[60,-21]
			label DLGshadowCastLabel "Shadow Casting:" align:#left
				button DLGselCastOn "On" width:30 height:16 offset:[30,-19]
				button DLGselCastOff "Off" width:30 height:16 offset:[60,-21]
			label DLGshadowReceiveLabel "Shadow Receive:" align:#left
				button DLGselReceiveOn "On" width:30 height:16 offset:[30,-19]
				button DLGselReceiveOff "Off" width:30 height:16 offset:[60,-21]
			label DLGmotionBlur "Motion Blur:" align:#left
				button DLGselMotionBlurOn "On" width:30 height:16 offset:[30,-19]
				button DLGselMotionBlurOff "Off" width:30 height:16 offset:[60,-21]
			label DLGmotionBlurType "Motion Blur Type:" align:#left offset:[0,2]
				dropdownlist DLGselMotionBlurType "" items:#("","None","Object","Image") width:61 offset:[88,-21]
		)
		on DLGselRendOn pressed do (
			local objs = for obj in objects where obj.renderable collect obj
			DoSelect objs
		)
		on DLGselRendOff pressed do (
			local objs = for obj in objects where NOT obj.renderable collect obj
			DoSelect objs
		)
		on DLGselCastOn pressed do (
			local objs = for obj in objects where obj.castShadows collect obj
			DoSelect objs
		)
		on DLGselCastOff pressed do (
			local objs = for obj in objects where NOT obj.castShadows collect obj
			DoSelect objs
		)
		on DLGselReceiveOn pressed do (
			local objs = for obj in objects where obj.receiveShadows collect obj
			DoSelect objs
		)
		on DLGselReceiveOff pressed do (
			local objs = for obj in objects where NOT obj.receiveShadows collect obj
			DoSelect objs
		)
		on DLGselMotionBlurOn pressed do (
			local objs = for obj in objects where obj.motionBlurOn collect obj
			DoSelect objs
		)
		on DLGselMotionBlurOff pressed do (
			local objs = for obj in objects where NOT obj.motionBlurOn collect obj
			DoSelect objs
		)
		on DLGselMotionBlurType selected idx do (
			DLGselMotionBlurType.selection = 1
			local objs = case idx of (
				2: for obj in objects where (obj.motionBlur == #none) OR (obj.motionBlur == false) collect obj
				3: for obj in objects where (obj.motionBlur == #object) OR (obj.motionBlur == true) collect obj
				4: for obj in objects where (obj.motionBlur == #image) collect obj
			)
			DoSelect objs
		)
	)

	rollout DLGsaveLoadRollout "Save / Load Selections" (
		fn saveArray fName ary = (
			local f = try (createfile fName) catch (undefined)
			if f == undefined then return false
			try (
				for i in ary do ( format "%\n" i to:f )
			) catch (
				close f
				return false
			)
			close f
			return true
		)

		fn loadArray fName ary = (
			local f = openFile fName mode:"r"
			if f == undefined then return false
			try (
				while (not eof f) do (
					local i = ((readline f) as integer)
					if i != undefined then append ary i
				)
			) catch (
				close f
				return false
			)
			close f
			return true
		)

		fn getObjToSave = (
			local obj = selection[1]
			if (obj == undefined) then (
				str = "Please select an editable mesh to save/load its sub-object selection."
				messageBox str title:"No Object Selected"
				return undefined
			)
			if (classOf obj != Editable_mesh) then (
				str = "Selected object is not an editable mesh, no selection will be saved/loaded."
				messageBox str title:"Not an Editable Mesh"
				return undefined
			)
			return obj
		)

		fn getSelectionNames selSet = (
			nameArray = for obj in selSet collect obj.name
		)

		fn saveSelFile fnm =
		(
			if (getNumNamedSelSets() > 0) do
			(
				--create the file
				local fout = try (createfile fnm) catch (undefined)
				if fout != undefined then
				(
					try
					(
						--make a header
						format "FromFile: %\n" maxFileName to:fout
						format "Location: %\n" maxFilePath to:fout
						format "NumSets: %\n" (selectionSets.count as string) to:fout
						--save each line
						for sel in 1 to selectionSets.count do
						(
							--save the selectionSet name and count
							format "setName: %\n" ((getNamedSelSetName sel)as string) to:fout
							format "count: %\n" ((selectionSets[sel].count) as string) to:fout
							--save info
							for nm in (getSelectionNames selectionSets[sel]) do format "%\n" nm to:fout
							--save Blank line
							format "%\n" " " to:fout
						)
						--close the file
						close fout
						return 1
					)
					catch (return 0)
				)
				else return 0
			)
		)

		fn loadSelFile fnm =
		(
			local fin = try (openFile fnm) catch (undefined)
			if fin != undefined then
			(
				try
				(
					--handle the header
					skipToNextLine fin
					skipToNextLine fin
					local NumSets = (replace (readLine fin) 1 9 "") as integer
					--print NumSets

					for s in 1 to NumSets do
					(
						local oArray = #()
						--get the selectionSet Name
						local sName = (replace (readLine fin) 1 9 "")
						--print sName
						--get count
						local cnt = (replace (readLine fin) 1 7 "") as integer
						--print cnt
						--getObjectNames
						local objsMissing = false
						local missingObjs = #()
						local inc = (100.0/cnt)
						for n in 1 to cnt do
						(
							local oName = readLine fin
							--replace spaces with other
							--for i in 1 to oName.count do if oName[i] == " " do oName[i] = "_"
							oName = ("$'" + oName + "'")
							obj = execute oName
							if (obj != undefined) then (
								append oArray obj
							) else (
								objsMissing = true
								append missingObjs oName
							)
							DLGsaveLoadRollout.DLGsetProgress.value = n / cnt as float * 100
						)
						if objsMissing then (
							format "Set \"%\" is missing the following objects:\n" sName
							for oName in missingObjs do (
								format "\t%\n" oName
							)
						)
						--skip one more line
						skipToNextLine fin

						--make selection set
						if oArray.count > 0 do selectionSets[sName] = oArray
						--update progress bar
						DLGsaveLoadRollout.DLGsetProgress.value = 0
						DLGsaveLoadRollout.DLGallProgress.value = s / numSets as float * 100
					)
					DLGsaveLoadRollout.DLGallProgress.value = 0
					close fin
					return 1
				) catch ( return 0 )
			)
			else
			(
				close fin
				return 0
			)
		)

		dropdownlist DLGlevel items:#("Object Selection Sets","Vertex Selection","Face Selection","Edge Selection")
		button DLGsaveSOsel "Save" align:#left height:18 width:70  offset:[-1,0] enabled:true
		button DLGloadSOsel "Load" align:#right height:18 width:70 offset:[1,-23] enabled:true
		progressBar DLGsetProgress width:150 height:8 color:blue align:#center
		progressBar DLGallProgress width:150 height:8 color:green align:#center offset:[0,-5]

		on DLGsaveSOsel pressed do (
			if DLGlevel.selection == OSS then (
				local fout = getSaveFileName caption:"Save Selection Set File" types:"Selection(*.oss)|*.oss|"
				if fout != undefined do saveSelFile fout
			) else (
				local obj = getObjToSave()
				if obj == undefined then return()
				local sel
				case DLGlevel.selection of (
					VSS: sel = getVertSelection obj
					FSS: sel = getFaceSelection obj
					ESS: sel = getEdgeSelection obj
				)
				if sel.count == 0 then (
					local str = "Nothing selected, nothing to save."
					messageBox str title:"No selection"
					return()
				)
				local fName
				case DLGlevel.selection of (
					VSS: fName = getSaveFileName caption:"Save Selection Set File" types:"Vertex Selection Set(*.vss)|*.vss|"
					FSS: fName = getSaveFileName caption:"Save Selection Set File" types:"Face Selection Set(*.fss)|*.fss|"
					ESS: fName = getSaveFileName caption:"Save Selection Set File" types:"Edge Selection Set(*.ess)|*.ess|"
				)
				if fName == undefined then return()
				if not (saveArray fName sel) then (
					local str = "Unabled to save file.  Check for permission and disk space."
					messageBox str title:"File Write Error"
				)
			)
		)

		on DLGloadSOsel pressed do (
			if DLGlevel.selection == OSS then (
				local fin = getOpenFileName caption:"Open Selection Set File" types:"Selection(*.oss)|*.oss|"
				if fin != undefined do loadSelFile fin
			) else (
				local obj = getObjToSave()
				if obj == undefined then return()
				local fName = case DLGlevel.selection of (
					VSS: getOpenFileName caption:"Save Selection Set File" types:"Vetex Selection Set(*.vss)|*.vss|"
					FSS: getOpenFileName caption:"Save Selection Set File" types:"Face Selection Set(*.fss)|*.fss|"
					ESS: getOpenFileName caption:"Save Selection Set File" types:"Edge Selection Set(*.ess)|*.ess|"
				)
				if fName == undefined then return()
				local sel = #()
				if not (loadArray fName sel) then (
					local str = "Unable to load file."
					messageBox str title:"File Read Error"
					return()
				)
				if sel.count == 0 then (
					local str = "Nothing saved in file, or invalid file.  Nothing selected."
					messageBox str title:"No selection"
				)
				case DLGlevel.selection of (
					VSS: setVertSelection obj sel
					FSS: setFaceSelection obj sel
					ESS: setEdgeSelection obj sel
				)
				update obj
			)
		)
	)

	rollout DLGnormSelRollout "Normal Select" (
		local angThresh
		local keepSel
		local vec
		local vecType
		local curAxis
		local vecObj

		fn updateUI = (
			DLGnormSelRollout.DLGvecTypeWorld.state = (vecType == #world)
			DLGnormSelRollout.DLGvecTypeObject.state = (vecType == #object)

			if (vecType == #world) do (
				vec = case curAxis of (
					#nx: [1,0,0]
					#px: [-1,0,0]
					#ny: [0,1,0]
					#py: [0,-1,0]
					#nz: [0,0,1]
					#pz: [0,0,-1]
				)
			)

			DLGnormSelRollout.DLGkeepSel.checked = keepSel
			DLGnormSelRollout.DLGvecLabel.text = if (objectExists vecObj) then vecObj.name else "-- none --"
			DLGnormSelRollout.DLGnx.enabled =
				DLGnormSelRollout.DLGpx.enabled =
				DLGnormSelRollout.DLGny.enabled =
				DLGnormSelRollout.DLGpy.enabled =
				DLGnormSelRollout.DLGnz.enabled =
				DLGnormSelRollout.DLGpz.enabled = (vecType == #world)
			DLGnormSelRollout.DLGpickVec.enabled =
				DLGnormSelRollout.DLGvecLabel.enabled = (vecType == #object)
			DLGnormSelRollout.DLGselectFaces.enabled = ((vecType != #object) OR (objectExists vecObj))
			DLGnormSelRollout.DLGnx.checked = (curAxis == #nx)
			DLGnormSelRollout.DLGpx.checked = (curAxis == #px)
			DLGnormSelRollout.DLGny.checked = (curAxis == #ny)
			DLGnormSelRollout.DLGpy.checked = (curAxis == #py)
			DLGnormSelRollout.DLGnz.checked = (curAxis == #nz)
			DLGnormSelRollout.DLGpz.checked = (curAxis == #pz)
		)

		group "Options" (
			label DLGangThreshLabel "Angle Threshold:" align:#left
			spinner DLGangThresh "" range:[0,180,45] type:#float fieldWidth:40 align:#right offset:[-5,-20]
			label DLGkeepSelLabel "Keep Selection:" align:#left
			checkbox DLGkeepSel "" align:#right offset:[7,-18]
		)
		group "Selection Direction" (
			checkbox DLGvecTypeWorld "World Axis"
			checkbutton DLGnx "-X" width:23 offset:[-64,0]
			checkbutton DLGpx "+X" width:23 offset:[-42,-26]
			checkbutton DLGny "-Y" width:23 offset:[-11,-26]
			checkbutton DLGpy "+Y" width:23 offset:[11,-26]
			checkbutton DLGnz "-Z" width:23 offset:[42,-26]
			checkbutton DLGpz "+Z" width:23 offset:[64,-26] checked:true
			checkbox DLGvecTypeObject "Object Direction"
			pickbutton DLGpickVec "Pick Object"
			label DLGvecLabel ""
		)
		button DLGselectFaces "Select Faces"

		on DLGangThresh changed val do ( angThresh = val; updateUI() )
		on DLGkeepSel changed state do ( keepSel = state; updateUI() )
		on DLGvecTypeWorld changed state do ( vecType = #world; updateUI() )
		on DLGvecTypeObject changed state do ( vecType = #object; updateUI() )
		on DLGnx changed state do ( curAxis = #nx; updateUI() )
		on DLGpx changed state do ( curAxis = #px; updateUI() )
		on DLGny changed state do ( curAxis = #ny; updateUI() )
		on DLGpy changed state do ( curAxis = #py; updateUI() )
		on DLGnz changed state do ( curAxis = #nz; updateUI() )
		on DLGpz changed state do ( curAxis = #pz; updateUI() )
		on DLGpickVec picked obj do ( vecObj = obj; updateUI() )

		on DLGselectFaces pressed do (
			local failed = false

			if (vecType == #object) do (
				if (objectExists vecObj) then (
					vec = vecObj.dir
				) else (
					updateUI()
					return()
				)
			)

			for obj in selection do (
				if (classOf obj == editable_mesh) AND (obj.modifiers.count == 0) then (
					local selFaces = getFacesByNormal obj vec angThresh
					if keepSel do selFaces += getFaceSelection obj
					setFaceSelection obj selFaces
				) else (
					failed = true
				)
			)

			updateUI()

			if failed do (
				messageBox "One or more of the selected objects was
not a collapsed, editable mesh, and was
excluded from selection." title:"Warning"
			)
		)

		on DLGnormSelRollout open do (
			angThresh = 45.0
			keepSel = false
			vecType = #world
			curAxis = #pz
			updateUI()
		)
	)

	thisTool.addRoll #(	DLGaboutRollout,
						DLGsaveLoadRollout,
						DLGmainRollout,
						DLGselectByObjProp,
						DLGnormSelRollout) rolledUp:#(true,true,false,true,true)

	thisTool.openTool thisTool
)
)
