macroScript UnwrapMesh
category:"fooTOOLS"
buttontext:"UnwrapMesh"
tooltip:"Unwrap - Unwraps A Mesh For Mapping"
icon:#("fooTOOLS-Icons",26)
(

------------------------------------------------------------------------------------------
-- Contents:
--		UnwrapMesh - Description: Unwraps A Mesh For Mapping
--
-- Requires:
--		jbFunctions.ms
--		avg_dlx.dlx
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",14), #("avg_dlx",2.09) )
	)
) then (

	local thisTool = BFDtool	toolName:"UnwrapMesh"		\
								author:"John Burnett"		\
								createDate:[2000,06,01]		\
								modifyDate:[2001,05,21]		\
								version:3					\
								defFloaterSize:[200,298]	\
								autoLoadRolloutStates:true	\
								autoLoadFloaterSize:true

	local SCALEFACTOR = 100.0

	local MAP_CHANNEL_OFFSET = if ((MaxVersion())[1] >= 4000) then 0 else 1

	rollout DLGaboutRollout "About" (
		button DLGhelp "Help"
		label DLGAbout01 "" offset:[0,5]
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGhelp pressed do (
			local helpStr = "Help Goes Here"
			messageBox helpStr title:"UnwrapMesh Help"
		)

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do ( thisTool.closeTool() )
	)

	rollout DLGmainRollout "Main Rollout" (
		local src, unwrap
		local chan

		fn validSrc obj quiet:true = (
			if (objectExists obj) then (
				if	(classOf obj == editable_mesh) AND
					(obj.modifiers.count == 0) then (
					local chan = DLGmainRollout.DLGchannel.value + MAP_CHANNEL_OFFSET
					if (meshOp.GetMapSupport obj chan) then (
						if	(objectExists unwrap) AND
							(obj.numFaces != unwrap.numFaces) then (
								if (NOT quiet) do messageBox "The two objects don't have the same face count..." title:"Error"
						) else (
							return true
						)
					) else (
						if (NOT quiet) do messageBox "Picked object doesn't have mapping applied to selected channel." title:"Error"
					)
				) else (
					if (NOT quiet) do messageBox "Picked object must be a collapsed editable mesh" title:"Error"
				)
			)
			return false
		)

		fn validUnwrap obj quiet:true = (
			if (objectExists obj) then (
				if	(canConvertTo obj editable_mesh) then (
					if	(objectExists src) AND
						(obj.numFaces != src.numFaces) then (
							if (NOT quiet) do messageBox "The two objects don't have the same face count..." title:"Error"
					) else (
						return true
					)
				) else (
					if (NOT quiet) do messageBox "Picked object is not valid as an unwrap mesh." title:"Error"
				)
			)
			return false
		)

		fn updateUI = (
			local R = DLGmainRollout
			R.DLGsourceLabel.text = if (validSrc src) then (snipString src.name 15) else "-- no source --"
			R.DLGunwrapLabel.text = if (validUnwrap unwrap) then (snipString unwrap.name 15) else "-- no unwrapped --"
			R.DLGexport.enabled = R.DLGmakeUVWmesh.enabled = (validSrc src)
			R.DLGimport.enabled = (validSrc src) AND (validUnwrap unwrap)
		)

		spinner DLGchannel "UVW Channel: " type:#integer range:[0,99,1] fieldWidth:25 align:#center offset:[0,8]
		group "Source" (
			label DLGsourceLabel "" align:#left across:2
			pickbutton DLGpickSource "Pick" align:#right offset:[2,0]
			button DLGexport "Create Unwrapped Mesh" tooltip:"Export Mapping To A New Mesh" width:150
			button DLGmakeUVWmesh "Create UVW As Mesh" tooltip:"Create a mesh using UVW topology and Object Geometry" width:150
		)
		button DLGimport "/\\ Import Unwrapped Mesh /\\" tooltip:"Import Unwrapped Mesh To Mapping" width:150 align:#center
		group "Unwrapped" (
			label DLGunwrapLabel "" align:#left across:2
			pickbutton DLGpickUnwrap "Pick" align:#right offset:[2,0]
		)

		on DLGchannel changed val do ( chan = val + MAP_CHANNEL_OFFSET; UpdateUI() )

		on DLGpickSource picked obj do (
			src = if (validSrc obj quiet:false) then obj else undefined
			UpdateUI()
		)

		on DLGpickUnwrap picked obj do (
			unwrap = if (validUnwrap obj quiet:false) then obj else undefined
			UpdateUI()
		)

		on DLGexport pressed do (
			if (validSrc src) then (
				unwrap = mesh	name:(src.name + "_UNWRAP")			\
								numVerts:(meshOp.GetNumMapVerts src chan)	\
								numFaces:src.numFaces

				for i in 1 to unwrap.numVerts do (
					setVert unwrap i ((meshOp.GetMapVert src chan i) * SCALEFACTOR)
				)

				for i in 1 to unwrap.numFaces do (
					SetFace unwrap i (meshOp.GetMapFace src chan i)
					for j in 1 to 3 do (
						SetEdgeVis unwrap i j (GetEdgeVis src i j)
					)
				)

				Update unwrap

				local m = UVWmap()
				AddModifier unwrap m
				--This causes the stack to be evaluated so I get get to the modifier gizmo
				--forceCompleteRedraw()
				RedrawViews()

				m.length = m.width = m.height = SCALEFACTOR
				--Setting UVWmap channel is broken in 3.1
				--m.channel = if (chan == 1) then chan else (chan - MAP_CHANNEL_OFFSET)
				m.gizmo.pos = [SCALEFACTOR/2.0, SCALEFACTOR/2.0, 0.0]
				m.gizmo.rotation = quat 0 0 1 0
				m.gizmo.scale = [1,1,1]

				unwrap.material = src.material
			)
			UpdateUI()
		)

		on DLGmakeUVWmesh pressed do (
			if (validSrc src) then (
				unwrap = mesh	name:(src.name + "_UVWasMESH") \
								numVerts:(meshOp.GetNumMapVerts src chan) \
								numFaces:src.numFaces

				meshOp.SetMapSupport unwrap chan true
				meshOp.SetNumMapVerts unwrap chan (meshOp.GetNumMapVerts src chan)
				meshOp.SetNumMapFaces unwrap chan src.numFaces

				for i in 1 to unwrap.numFaces do (
					local mapVerts = meshOp.GetMapFace src chan i
					local objVerts = GetFace src i

					SetFace unwrap i mapVerts

					for j in 1 to 3 do (
						SetEdgeVis unwrap i j (GetEdgeVis src i j)
						case j of (
							1: SetVert unwrap mapVerts.x (GetVert src objVerts.x)
							2: SetVert unwrap mapVerts.y (GetVert src objVerts.y)
							3: SetVert unwrap mapVerts.z (GetVert src objVerts.z)
						)
					)

					meshOp.SetMapFace unwrap chan i (meshOp.GetMapFace src chan i)
				)

				for i in 1 to unwrap.numVerts do (
					meshOp.SetMapVert unwrap chan i (meshOp.GetMapVert src chan i)
				)

				update unwrap

				unwrap.material = src.material
			)
			updateUI()
		)

		on DLGimport pressed do (
			if (validSrc src) AND (validUnwrap unwrap) then (
				local uMesh = unwrap.mesh
				meshOp.SetNumMapVerts src chan uMesh.numVerts
				for i in 1 to uMesh.numFaces do (
					meshOp.SetMapFace src chan i (getFace uMesh i)
				)
				for i in 1 to uMesh.numVerts do (
					meshOp.SetMapVert src chan i ((getVert uMesh i) / SCALEFACTOR)
				)
				update src
			)
			updateUI()
		)

		on DLGmainRollout open do (
			src = unwrap = undefined
			chan = DLGchannel.value + MAP_CHANNEL_OFFSET
			updateUI()
		)
	)

	thisTool.addRoll #(DLGaboutRollout,DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
