macroScript WireColorMan
category:"fooTOOLS"
buttontext:"WireColorMan"
tooltip:"WireColorMan - WireColor Manager"
icon:#("fooTOOLS-Icons",27)
(

------------------------------------------------------------------------------------------
-- Contents:
--		WireColorMan - Description: WireColor Manager
--
-- Requires:
--		jbFunctions.ms
------------------------------------------------------------------------------------------

if (
	if (jbFunctionsCurrentVersion == undefined OR (jbFunctionsCurrentVersion() < 11)) then (
		local str = "This script requires jbFunctions to run properly.\n\nYou can get the latest version at http://www.footools.com/.\n\nWould you like to connect there now?"
		if (QueryBox str title:"Error") then ( try (ShellLaunch "http://www.footools.com/" "") catch () )
		FALSE
	) else (
		jbFunctionsVersionCheck #( #("jbFunctions",11) )
	)
) then (

	local thisTool = BFDtool	toolName:"WireColorMan"		\
								author:"John Burnett"		\
								createDate:[1999,01,28]		\
								modifyDate:[2001,08,26]		\
								version:1					\
								defFloaterSize:[150,192]

	local colArray = #(color 86 86 86, color 227 152 152, color 228 184 153, color 228 214 153, color 214 228 153, color 184 228 153, color 153 228 153,
		color 153 228 184, color 153 228 214, color 154 215 229, color 154 185 229, color 154 154 229, color 184 155 229, color 213 154 229,
		color 229 154 215, color 228 153 184, color 87 224 198, color 224 86 86, color 224 143 87, color 224 198 87, color 198 224 87,
		color 143 224 87, color 87 224 87, color 87 224 143, color 229 166 215, color 88 199 225, color 88 143 225, color 88 88 225,
		color 140 88 225, color 196 88 225, color 225 88 199, color 224 87 143, color 26 177 148, color 176 26 26, color 177 88 26,
		color 177 148 26, color 148 177 26, color 88 177 26, color 26 177 26, color 26 177 88, color 214 229 166, color 28 149 177,
		color 28 89 177, color 28 28 177, color 85 28 177, color 145 28 177, color 177 28 149, color 177 26 88, color 6 134 113,
		color 134 6 6, color 134 59 8, color 134 110 8, color 113 134 6, color 61 134 6, color 6 134 6, color 6 134 58, color 166 229 229,
		color 8 110 134, color 8 61 138, color 8 8 136, color 57 8 136, color 108 8 136, color 138 8 110, color 141 7 58)

	fn getRoots objs = (
		objs = objs as array
		local par = #()
		for obj in objs do (
			if (obj.parent == undefined) OR
				((findItem objs obj.parent)==0) then append par obj )
		return par
	)

	fn uniqueCol objs colArray = (
		local rndCol = random 1 colArray.count
		for obj in objs do (
			try ( obj.wireColor = colArray[rndCol] ) catch ()
		)
	)

	rollout DLGaboutRollout "About" (
		button DLGhelp "HELP"
		label DLGAbout01 "" offset:[0,5]
		label DLGAbout02 ""
		label DLGAbout03 ""

		on DLGhelp pressed do (
			local STRwcManHelp = "WireColor Manager lets you work with object wireframe colors to quickly
build selections based on colors.

Select Same - Select an object or group of objects, and hit this to select
  everything in the scene that shares the same wirecolor(s).

Each Obj. in Sel. - Select a group of objects and hit this to give each
  object a random wireframe color.

One for Entire Sel. - Select a group of objects and hit this to give
  the entire selection one random wireframe color."
			messageBox STRwcManHelp title:"WireColor Manager Help"
		)

		on DLGaboutRollout open do (
			DLGabout01.text = thisTool.toolName
			DLGabout02.text = thisTool.author
			DLGabout03.text =	(thisTool.modifyDate.x as integer) as string + "." +
								(thisTool.modifyDate.y as integer) as string + "." +
								(thisTool.modifyDate.z as integer) as string
		)

		on DLGaboutRollout close do (
			thisTool.closeTool()
		)
	)

	rollout DLGmainRollout "Main Rollout" (
		button DLGselectSame "Select Same" tooltip:"Select all objects that have the same wirecolor as current object." width:100 align:#center
		group "Random Color For:" (
			button DLGuniqueColObj "Each Obj. in Sel." width:100 align:#center
			button DLGuniqueColSel "One for Entire Sel." width:100 align:#center
		)

		on DLGselectSame pressed do (
			if selection.count == 0 then return()
			local targCols = #()
			local tmp
			for obj in selection do (
				try (
					tmp = obj.wirecolor
					if (findItem targCols tmp) == 0 then append targCols tmp
				) catch ()
			)
			if targCols.count == 0 then return()
			local selMe = #()
			for targCol in targCols do (
				for obj in objects where NOT obj.isHidden do (
					try (if obj.wireColor == targCol then append selMe obj) catch ()
				)
			)
			undo on ( select selMe )
		)

		on DLGuniqueColObj pressed do (
			for obj in selection do (
				uniqueCol obj colArray
			)
		)

		on DLGuniqueColSel pressed do (
			uniqueCol selection colArray
		)
	)

	thisTool.addRoll #(DLGaboutRollout,
				DLGmainRollout) rolledUp:#(true,false)

	thisTool.openTool thisTool
)
)
