---------------------------------------------------------------------------------------
--psuedoNURBS Script v1.53
--(c)1998 John Burnett, jburnett@blizzard.com
--
--This script speeds up the workflow when working with referenced, meshsmoothed
--objects.  It's basically a massively souped up, interactive version of the
--MetaPete.ms script that shipped with Max2.0.  Please see pnurbs.txt for more
--information on usage.
--
--v1.5 - Ouch... after all this, it's painfully obvious that I had no idea what
--       I was doing back then... of course, I'm in total control now :P
--     - Replaced trunc function calls with the now standard snipStr in string.ms
--     - Made 180 the default value for smoothing
--     - Did a very quick hack to (hopefully) prevent the smooth spinner
--       from being disabled when it shouldn't be.
--     - Compacted the interface a bit with a dropdown list/spinner combo... this
--       was something that was going to wait for v2.0 to put in, but since that
--       code was already done, and I'm screwing with v1.0 anyway, I put it in...
--     - Beware that this code is now _completely_ screwed, and is put together
--       with glue and duct tape. However, it seems to be a bit more stable as well
--       (try()catch() is your friend)...
--v1.51 - Fixed a bug that caused Max to crash when you turned off pNURBS with
--        PNMesh selected, and the modifier panel open.
--v1.52 - Made the lattice non-renderable
--v1.53 - Update to Max 3.0, no different than 1.52 in functionality
--		  uses NURMS instead of Quad output
--		  case statements of 2: and 4: were swapped since Relax and Strength are gone now
--		  smooth now no longer -1 from UI value
--
-----------------------------------------------------------------------
--While this script has been reasonably tested, and  it _shouldn't_ do
--nasty things to your computer, I won't be held responsible if it
--does. Use it at your own risk.
--
--Feel free to modify, or use portions of, this script in your own
--scripts, but please include credit where it is due:
--( John Burnett, jburnett@blizzard.com ).  Also, please change the
--name and/or version number, and e-mail me a copy if possible :).
--
--If this script doesn't do something you think it should or you find
--bugs, please e-mail me at jburnett@blizzard.com
-----------------------------------------------------------------------
--User defined settings------------------------------------------------
-----------------------------------------------------------------------
floaterXpos=675
floaterYpos=65
displayFloaterOnRun=false
-----------------------------------------------------------------------

PNFloater --this needs to be here for createFloater() to work? (Ack! A cludge!)
PNRollout
global PNLat
global PNMesh
global objType
global PNsmooth
global PNrelax
global PNstrength
global PNSharpness
PNsmooth = 180.0
PNrelax = 0.0
PNstrength = 0.5
PNSharpness = 1.0

fn updateDisplay = (
	--check all other controls as well (enable, sel. only, man. update, etc)

	--update dropdown list and spinner
	PNRollout.DLGvariList.items = #("Smooth:             " + PNsmooth as string,
										--"Relax:                 " + PNrelax as string,
										--"Strength:             " + PNstrength as string,
										"Sharpness:          " + PNsharpness as string)
	case PNRollout.DLGvariList.selection of
	(
		1: (
			PNRollout.DLGvariSpin.range = [-1,180,PNsmooth]
			PNRollout.DLGvariSpin.value = PNsmooth
			case of (
				(PNSmooth == 180):
				(
					try (
						try ( deleteModifier PNMesh PNMesh.PN_smooth ) catch ()
						PNMesh.PN_meshsmooth.smooth_output = 1
					) catch ()
				)
				(PNSmooth == 0):
				(
					try (
						try ( PNMesh.PN_smooth.autosmooth = false )
						catch ( addModifier PNMesh ( smooth name:"PN_smooth" autosmooth:false ) )
						PNMesh.PN_meshsmooth.smooth_output = 0
					) catch ()
				)
				(PNSmooth < 0):
				(
					try (
						try ( deleteModifier PNMesh PNMesh.PN_smooth ) catch ()
						PNMesh.PN_meshsmooth.smooth_output = 0
					) catch ()
				)
				default:
				(
					try (
						try
						(
							PNMesh.PN_smooth.autosmooth = true
							PNMesh.PN_smooth.threshold = PNsmooth
						)
						catch ( addModifier PNMesh ( smooth name:"PN_smooth" autosmooth:true threshold:PNsmooth ) )
						PNMesh.PN_meshsmooth.smooth_output = 0
					) catch ()
				)
			)
		)
		--swap pos 4 and 2, v1.53 for Max3.0
		4: (
			PNRollout.DLGvariSpin.range = [-1,1,PNrelax]
			PNRollout.DLGvariSpin.value = PNrelax
			try (if PNMesh != undefined then PNMesh.PN_meshsmooth.relax = PNRelax) catch ()
		)
		3: (
			PNRollout.DLGvariSpin.range = [0,1,PNstrength]
			PNRollout.DLGvariSpin.value = PNstrength
			try (if PNMesh != undefined then PNMesh.PN_meshsmooth.strength = PNstrength) catch ()
		)
		2: (
			PNRollout.DLGvariSpin.range = [0,1,PNsharpness]
			PNRollout.DLGvariSpin.value = PNsharpness
			try (if PNMesh != undefined then PNMesh.PN_meshsmooth.Smoothness_Filter = PNsharpness) catch ()
		)
	)
)

fn initGlobals = (
	PNsmooth = 180.0
	PNrelax = 0.0
	PNstrength = 0.5
	PNSharpness = 1.0
)

fn snipStrPN str n = (
	if n <= 1 then (return substring str 1 1)
	local ln = str.count as integer
	if ln <= n then (return str)
	else (
		local half = n / 2.0
		(substring str 1 half) + "~" + (substring str (ln-(half-2)) (half-0.5))
	)
)

rollout PNRollout "psuedoNURBS"
(
	pickbutton pick "Pick Object" filter:validLattice width:130 height:18 pos:[4,8]
	checkbutton action "Enable psuedoNURBS" highlightColor:(color 127 255 127) width:130 height:18 enabled:false align:#center
	
	group "Tesselation/Properties" (
	radiobuttons tess labels:#("1", "2", "3", "4") default:1 columns:4

	dropdownlist DLGvariList items:#("-----------------------------------") selection:1 width:67 across:2 offset:[-3,-2]
	spinner DLGvariSpin range:[-1,180,180] type:#float scale:0.1 fieldWidth:40 offset:[3,0]
	)

	group "Display Properties"
	(
		checkbox updatePNcheck checked:false across:2 offset:[2,-1]
		button updatePN "Manual Update" offset:[-21,-2] height:16 enabled:false
		checkbox latVis "Lattice" checked:true offset:[2,0] across:2
		checkbox meshVis "Mesh" checked:true offset:[2,0]
	)
	
	on pick picked node do
	(
		obj = node
		if isValid node == true then
		(
			PNRollout.action.enabled = true
			getObjType obj
			if (objType == "PNLat") or (objType == "PNMesh") then
			(
				pick.text = snipStrPN PNLat.name 15
			)
			else
			(			
				pick.text = snipStrPN obj.name 15
			)
			if objType == "Mesh" then
			(
				PNRollout.action.checked = off
				PNRollout.action.text = "Enable psuedoNURBS"
			)
			else
			(
				PNRollout.action.checked = on
				PNRollout.action.text = "Disable psuedoNURBS"
				updateFloater()
			)
		)
		else
		(
			PNRollout.action.enabled = false
			pick.text = "Invalid Object"
		)			
	)
	
	on action changed val do
	(
		if val == on then
		(
			PNRollout.action.text = "Disable psuedoNURBS"
			if not isDeleted obj then createPN obj
			if isDeleted obj then
			(
				PNRollout.action.checked = false
				PNRollout.action.enabled = false
				PNRollout.pick.text = "Pick Object"
				PNRollout.action.text = "Enable psuedoNURBS"
			)
		)
		else
		(
			PNRollout.action.text = "Enable psuedoNURBS"
			if not isDeleted obj then deletePN obj
			if isDeleted obj then
			(
				PNRollout.action.enabled = false
				PNRollout.pick.text = "Pick Object"
			)
		)
	)
	
	on DLGvariList selected val do
	(
		updateDisplay()
	)

	on DLGvariSpin changed val do
	(
		case PNRollout.DLGvariList.selection of
		(
			1: PNsmooth = val
			4: PNrelax = val
			3: PNstrength = val
			2: PNsharpness = val
		)
		updateDisplay()
	)

	on tess changed val do
	(
		try (if (not isDeleted PNMesh) or (PNMesh != undefined) then PNMesh.PN_meshsmooth.iterations = val) catch ()
		updateDisplay()
	)
	
	on updatePNcheck changed val do
	(
		try (
			if PNMesh != undefined then
			(
				if val == true then
				(
					PNMesh.PN_meshsmooth.Update_Options = 2
				)
				else
				(
					PNMesh.PN_meshsmooth.Update_Options = 0
				)
				PNRollout.updatePN.enabled = val
			)
		) catch ()
		updateDisplay()
	)
	
	on updatePN pressed do
	(
		try (
			if PNMesh != undefined then
			(
				PNMesh.PN_meshsmooth.update_options = 0
				max views redraw
				PNMesh.PN_meshsmooth.update_options = 2
			)
		) catch ()
		updateDisplay()
	)
	
	on latVis changed val do
	(
		try (
			if PNLat != undefined then PNLat.isHidden = not latVis.checked
		) catch ()
	)
		
	on meshVis changed val do
	(
		try (
			if PNMesh != undefined then PNMesh.isHidden = not meshVis.checked
		) catch ()
	)
)

fn getObjType node=
(
	-- if node has children, see if one of them is a PN mesh object
	if node.children.count != 0 then
	(
		for i = 1 to node.children.count do
		(
			if node.children[i].name == "PN_"+node.name then
			(
				-- node is a lattice, set globals accordingly
				PNLat = node
				PNMesh = node.children[i]
				objType = "PNLat"
				return 1
			)
		)
	)
	-- if node is a PN mesh, set globals
	if (substring node.name 1 3) == "PN_" then
	(
		PNMesh = node
		PNLat = node.parent
		objType = "PNMesh"
		return 1
	)
	-- otherwise exit, setting globals to undefined
	PNLat = undefined
	PNMesh = undefined
	objType = "Mesh"
)

fn isValid node=
(
	local cp = copy node
	try
	(
		addModifier cp (normalModifier())
		delete cp
		return true
	)
	catch
	(
		delete cp
		return false
	)
)

fn createPN node =
(
	PNLat = node
	convertToMesh PNLat
	tmpWireColor = PNLat.wirecolor
	PNMesh = reference PNLat
	PNMesh.wireColor = tmpWireColor
	PNMesh.name = "PN_" + PNLat.name
	if PNLat.material != undefined then PNMesh.material = PNLat.material
	PNLat.material = standardmaterial name:"PNMaterial" wire:true twosided:false ambient:(color 60 60 60) diffuse:(color 60 60 60) shininess:0 shinestrength:0 selfillum:100
	PNLat.renderable = false
	PNMesh.renderable = true
	if PNRollout.updatePNcheck.checked == true then manUp = 2 else manUp = 0
	addModifier PNMesh							\
	(
		meshsmooth									\
			name:"PN_meshsmooth"					\
			apply_to_whole_mesh:1					\
			smooth_output:1							\
			iterations:(PNRollout.tess.state)		\
			Quad_Output:2							\
			Relax:PNRelax							\
			Strength:PNStrength						\
			Sharpness:PNSharpness					\
			Update_Options:manUp					\
	)
	PNLat.isHidden = not PNRollout.latVis.checked
	PNMesh.isHidden = not PNRollout.meshVis.checked
	PNMesh.parent = PNLat
	select PNLat
	--max modify mode
	--max subobject sel
)

fn deletePN node =
(
	if PNMesh.isSelected then deselect PNMesh
	selectMore PNLat
	if PNMesh.material != undefined then
	(
		PNLat.material = PNMesh.material
	)
	else
	(
		PNLat.material = standardmaterial name:"PNMaterial" ambient:black diffuse:(color 197 197 197) shininess:25 shinestrength:5
	)
	delete PNMesh
	PNLat.renderable = true
	--PNLat = undefined
	PNMesh = undefined
)

fn validLattice obj = superClassOf obj == GeometryClass

fn updateFloater =
(
	PNRollout.tess.state = (PNMesh.PN_meshsmooth.iterations+1)
	try ( PNrelax = PNMesh.PN_meshsmooth.relax ) catch ()
	try ( PNsmooth = PNMesh.PN_Smooth.threshold ) catch (
		if PNMesh.PN_meshsmooth.smooth_output == 0 then PNsmooth = 0
		if PNMesh.PN_meshsmooth.smooth_output == 1 then PNsmooth = 180
	)
	try (
		if PNMesh.PN_meshsmooth.Update_Options == 0 then
		(
			PNRollout.updatePNcheck.checked = false
			PNRollout.updatePN.enabled = false
		)
		else
		(
			PNMesh.PN_meshsmooth.Update_Options = 2
			PNRollout.updatePNcheck.checked = true
			PNRollout.updatePN.enabled = true
		)
	) catch ()
	PNRollout.latVis.checked = not PNLat.isHidden
	PNRollout.meshVis.checked = not PNMesh.isHidden
	updateDisplay()
)

fn controlsEnabled bool =
(
	PNRollout.tess.enabled = bool
	PNRollout.relax.enabled = bool
	PNRollout.DLGsmoothAngle.enabled = bool
	PNRollout.updatePNcheck.enabled = bool
	PNRollout.updatePN.enabled = bool
	PNRollout.latVis.enabled = bool
	PNRollout.meshVis.enabled = bool
)

-- removes the old PNFloater before creating a new one
-- prevents creating an empty dummy floater the PNFloater already exists
fn createFloater =
(
	try
	(
		closeRolloutFloater PNFloater
	)
	catch
	(
	)
	PNFloater = newRolloutFloater "pNURBS" 165 246 --floaterXpos floaterYpos
	addRollout PNRollout PNFloater
	initGlobals()
)

utility psuedoNURBS "psuedoNURBS 1.53"
(
	button floatme "psuedoNURBS Floater" width:140 offset:[-1,0]
	label blank01
	label aboutme02 "psuedoNURBS 1.53"
	label aboutme03 "\xa9 1998, John Burnett"
	label aboutme04 "jburnett@blizzard.com"
	label aboutme05 "See pNURBS-1_5.html" offset:[0,10]
	label aboutme06 "for help."
	label blank02
	on floatme pressed do (
		createFloater()
		updateDisplay()
	)
)

if displayFloaterOnRun == true then createFloater()
